/*---------------------------------------------------------------------------
  Module FmBitmaps

  (c) Simon Marlow 1990-92
  
  Functions & data for handling the bitmaps and cursors.
---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>

#include "bitmaps/l_line"
#include "bitmaps/t_line"
#include "bitmaps/f_line"
#include "bitmaps/c_line"
#include "bitmaps/l_arrow"
#include "bitmaps/r_arrow"
#include "bitmaps/dir_def"
#include "bitmaps/file_def"
#include "bitmaps/command_def"
#include "bitmaps/no_entry"
#include "bitmaps/xfm_icon"
#include "bitmaps/tick_bm"
#include "bitmaps/no_tick"
#include "bitmaps/files_def"
#include "bitmaps/exclamation"
#include "bitmaps/file_mask"
#include "bitmaps/dir_mask"
#include "bitmaps/command_mask"
#include "bitmaps/wavy_arrow"
#include "bitmaps/symlink"
#include "bitmaps/watch"
#include "bitmaps/watchmsk"
#include "bitmaps/dirlink"
#include "bitmaps/execlink"
#include "bitmaps/app_default"
#include "bitmaps/appmgr"
#include "bitmaps/files_mask"
#include "bitmaps/no_entry_mask"
#include "bitmaps/black_hole"

#include "Am.h"
#include "Fm.h"

/*-----------------------------------------------------------------------------
  STATIC DATA
-----------------------------------------------------------------------------*/

typedef struct {
  char *bits;
  int width, height;
} BitmapRec;

#ifdef __GNUC__
#define ICON(x) { x##_bits, x##_width, x##_height }
#else
#define ICON(x) { x/**/_bits, x/**/_width, x/**/_height }
#endif

static BitmapRec bitmaps[] = {
  ICON(l_line), ICON(t_line), ICON(f_line), ICON(c_line), ICON(l_arrow),
  ICON(r_arrow), ICON(dir_def), ICON(file_def), ICON(no_entry), ICON(xfm_icon),
  ICON(tick_bm), ICON(no_tick), ICON(command_def), ICON(files_def), 
  ICON(exclamation), ICON(file_mask), ICON(dir_mask), ICON(command_mask),
  ICON(wavy_arrow), ICON(symlink), ICON(watch), ICON(watchmsk), ICON(dirlink),
  ICON(execlink), ICON(app_default), ICON(appmgr), ICON(files_mask), 
  ICON(no_entry_mask), ICON(black_hole)
};

typedef struct {
  int source, mask;
} CursorRec;

static CursorRec cursors[] = {
  { FILE_BM, FILEMSK_BM },
  { FILES_BM, FILESMSK_BM },
  { NOENTRY_BM, NOENTRYMSK_BM },
  { DIR_BM, DIRMSK_BM },
  { COMMAND_BM, COMMANDMSK_BM },
  { WATCH_BM, WATCHMSK_BM }
};

/*-----------------------------------------------------------------------------
  PUBLIC DATA
-----------------------------------------------------------------------------*/

Pixmap *bm;
Cursor *curs;

/*-----------------------------------------------------------------------------
  PUBLIC FUNCTIONS
-----------------------------------------------------------------------------*/

void readBitmaps()
{
  int i;
  Display *dpy;
  int scrn;
  Colormap cmp;
  Window win;
  XColor black, white;

  dpy = XtDisplay(aw.shell);
  win = DefaultRootWindow(dpy);
  scrn = DefaultScreen(dpy);
  cmp = DefaultColormap(dpy, scrn);

  black.pixel = BlackPixel(dpy, scrn);
  XQueryColor(dpy, cmp, &black);
  white.pixel = WhitePixel(dpy, scrn);
  XQueryColor(dpy, cmp, &white);

  bm = (Pixmap *) XtMalloc(XtNumber(bitmaps) * sizeof(Pixmap *));
  curs = (Cursor *) XtMalloc(XtNumber(cursors) * sizeof(Cursor *));

  /* create the Pixmaps needed */
  for (i=0; i<XtNumber(bitmaps); i++)
    bm[i] = XCreateBitmapFromData(dpy, win, bitmaps[i].bits,
				  bitmaps[i].width, bitmaps[i].height);

  /* create the Cursors needed */
  for (i=0; i<XtNumber(cursors); i++)
    curs[i] = XCreatePixmapCursor(dpy, bm[cursors[i].source], 
				  bm[cursors[i].mask], &black, &white, 16, 16);
}

