/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import mso.generator.JavaParserGenerator;
import mso.generator.MSO;
import mso.generator.QtApiGenerator;
import mso.generator.QtParserGenerator;
import org.w3c.dom.Document;

public class ParserGeneratorRunner {
    public static void main(String[] stringArray) throws Exception {
        ParserGeneratorRunner parserGeneratorRunner = new ParserGeneratorRunner();
        new File("src/mso/javaparser").mkdirs();
        new File("cpp").mkdirs();
        Validator validator = parserGeneratorRunner.createValidator("mso.xsd");
        validator.validate(new StreamSource(parserGeneratorRunner.open("mso.xml")));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(parserGeneratorRunner.open("mso.xml"));
        MSO mSO = new MSO(document);
        parserGeneratorRunner.generateJavaParser(mSO);
        parserGeneratorRunner.generateQtParser(mSO);
        parserGeneratorRunner.generateSimpleQtParser(mSO);
        parserGeneratorRunner.generateApi(mSO);
    }

    void generateJavaParser(MSO mSO) throws IOException {
        JavaParserGenerator javaParserGenerator = new JavaParserGenerator();
        javaParserGenerator.generate(mSO, "src", "mso.javaparser", "GeneratedMsoParser");
    }

    void generateQtParser(MSO mSO) throws IOException {
        QtParserGenerator qtParserGenerator = new QtParserGenerator();
        qtParserGenerator.config.namespace = "";
        qtParserGenerator.config.basename = "generatedclasses";
        qtParserGenerator.config.outputdir = "cpp";
        qtParserGenerator.config.createHeader = false;
        qtParserGenerator.config.enableIntrospection = true;
        qtParserGenerator.config.enableXml = true;
        qtParserGenerator.config.enableWriting = true;
        qtParserGenerator.config.enableToString = true;
        qtParserGenerator.config.enableStyleTextPropAtomFix = false;
        qtParserGenerator.generate(mSO);
    }

    void generateSimpleQtParser(MSO mSO) throws IOException {
        QtParserGenerator qtParserGenerator = new QtParserGenerator();
        qtParserGenerator.config.namespace = "MSO";
        qtParserGenerator.config.basename = "simpleParser";
        qtParserGenerator.config.outputdir = "cpp";
        qtParserGenerator.config.createHeader = true;
        qtParserGenerator.config.enableIntrospection = false;
        qtParserGenerator.config.enableXml = false;
        qtParserGenerator.config.enableWriting = false;
        qtParserGenerator.config.enableToString = false;
        qtParserGenerator.config.enableStyleTextPropAtomFix = true;
        qtParserGenerator.generate(mSO);
    }

    void generateApi(MSO mSO) throws IOException {
        QtApiGenerator qtApiGenerator = new QtApiGenerator();
        qtApiGenerator.config.namespace = "MSO";
        qtApiGenerator.config.basename = "api";
        qtApiGenerator.config.outputdir = "cpp";
        qtApiGenerator.config.createHeader = true;
        qtApiGenerator.generate(mSO);
    }

    InputStream open(String string) throws Exception {
        File file = new File(string);
        if (file.canRead()) {
            System.out.println("Reading " + file.getAbsolutePath());
            return new FileInputStream(file.getAbsolutePath());
        }
        file = new File("src/" + string);
        if (file.canRead()) {
            System.out.println("Reading " + file.getAbsolutePath());
            return new FileInputStream(file.getAbsolutePath());
        }
        System.out.println("Reading " + string + " from jar file.");
        return this.getClass().getResourceAsStream("/" + string);
    }

    Validator createValidator(String string) throws Exception {
        String string2 = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory schemaFactory = SchemaFactory.newInstance(string2);
        Source[] sourceArray = new Source[]{new StreamSource(this.open(string))};
        Schema schema = schemaFactory.newSchema(sourceArray);
        return schema.newValidator();
    }
}

