/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGMatrix.h"

#include "JSSVGMatrix.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGMatrix);

/* Hash table */

static const HashTableValue JSSVGMatrixTableValues[8] =
{
    { "a", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixA), (intptr_t)setJSSVGMatrixA },
    { "b", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixB), (intptr_t)setJSSVGMatrixB },
    { "c", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixC), (intptr_t)setJSSVGMatrixC },
    { "d", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixD), (intptr_t)setJSSVGMatrixD },
    { "e", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixE), (intptr_t)setJSSVGMatrixE },
    { "f", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixF), (intptr_t)setJSSVGMatrixF },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGMatrixTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGMatrixTableValues, 0 };
#else
    { 17, 15, JSSVGMatrixTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGMatrixConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGMatrixConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGMatrixConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGMatrixConstructorTableValues, 0 };
#endif

class JSSVGMatrixConstructor : public DOMConstructorObject {
public:
    JSSVGMatrixConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGMatrixConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGMatrixPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGMatrixConstructor::s_info = { "SVGMatrixConstructor", 0, &JSSVGMatrixConstructorTable, 0 };

bool JSSVGMatrixConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMatrixConstructor, DOMObject>(exec, &JSSVGMatrixConstructorTable, this, propertyName, slot);
}

bool JSSVGMatrixConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGMatrixConstructor, DOMObject>(exec, &JSSVGMatrixConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGMatrixPrototypeTableValues[12] =
{
    { "multiply", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionMultiply), (intptr_t)1 },
    { "inverse", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionInverse), (intptr_t)0 },
    { "translate", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionTranslate), (intptr_t)2 },
    { "scale", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionScale), (intptr_t)1 },
    { "scaleNonUniform", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionScaleNonUniform), (intptr_t)2 },
    { "rotate", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionRotate), (intptr_t)1 },
    { "rotateFromVector", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionRotateFromVector), (intptr_t)2 },
    { "flipX", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionFlipX), (intptr_t)0 },
    { "flipY", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionFlipY), (intptr_t)0 },
    { "skewX", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionSkewX), (intptr_t)1 },
    { "skewY", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionSkewY), (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGMatrixPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGMatrixPrototypeTableValues, 0 };
#else
    { 33, 31, JSSVGMatrixPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGMatrixPrototype::s_info = { "SVGMatrixPrototype", 0, &JSSVGMatrixPrototypeTable, 0 };

JSObject* JSSVGMatrixPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGMatrix>(exec, globalObject);
}

bool JSSVGMatrixPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGMatrixPrototypeTable, this, propertyName, slot);
}

bool JSSVGMatrixPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGMatrixPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGMatrix::s_info = { "SVGMatrix", 0, &JSSVGMatrixTable, 0 };

JSSVGMatrix::JSSVGMatrix(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<JSSVGPODTypeWrapper<AffineTransform> > impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGMatrix::~JSSVGMatrix()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGMatrix::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGMatrixPrototype(JSSVGMatrixPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGMatrix::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, this, propertyName, slot);
}

bool JSSVGMatrix::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, this, propertyName, descriptor);
}

JSValue jsSVGMatrixA(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.a());
    return result;
}

JSValue jsSVGMatrixB(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.b());
    return result;
}

JSValue jsSVGMatrixC(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.c());
    return result;
}

JSValue jsSVGMatrixD(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.d());
    return result;
}

JSValue jsSVGMatrixE(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.e());
    return result;
}

JSValue jsSVGMatrixF(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.f());
    return result;
}

JSValue jsSVGMatrixConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* domObject = static_cast<JSSVGMatrix*>(asObject(slotBase));
    return JSSVGMatrix::getConstructor(exec, domObject->globalObject());
}
void JSSVGMatrix::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGMatrix, Base>(exec, propertyName, value, &JSSVGMatrixTable, this, slot);
}

void setJSSVGMatrixA(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    podImp.setA(value.toNumber(exec));
    imp->commitChange(podImp, castedThisObj);
}

void setJSSVGMatrixB(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    podImp.setB(value.toNumber(exec));
    imp->commitChange(podImp, castedThisObj);
}

void setJSSVGMatrixC(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    podImp.setC(value.toNumber(exec));
    imp->commitChange(podImp, castedThisObj);
}

void setJSSVGMatrixD(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    podImp.setD(value.toNumber(exec));
    imp->commitChange(podImp, castedThisObj);
}

void setJSSVGMatrixE(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    podImp.setE(value.toNumber(exec));
    imp->commitChange(podImp, castedThisObj);
}

void setJSSVGMatrixF(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    podImp.setF(value.toNumber(exec));
    imp->commitChange(podImp, castedThisObj);
}

JSValue JSSVGMatrix::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGMatrixConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionMultiply(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    return castedThisObj->multiply(exec, args);
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionInverse(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    return castedThisObj->inverse(exec, args);
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionTranslate(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.translate(x, y)).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScale(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    float scaleFactor = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.scale(scaleFactor)).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScaleNonUniform(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    float scaleFactorX = args.at(0).toFloat(exec);
    float scaleFactorY = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.scaleNonUniform(scaleFactorX, scaleFactorY)).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotate(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    float angle = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.rotate(angle)).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotateFromVector(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    return castedThisObj->rotateFromVector(exec, args);
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipX(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.flipX()).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipY(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.flipY()).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewX(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    float angle = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.skewX(angle)).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewY(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThisObj->impl());
    AffineTransform podImp(*imp);
    float angle = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.skewY(angle)).get(), 0 /* no context on purpose */);
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, JSSVGPODTypeWrapper<AffineTransform>* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGMatrix, JSSVGPODTypeWrapper<AffineTransform> >(exec, globalObject, object, context);
}
AffineTransform toSVGMatrix(JSC::JSValue value)
{
    return value.inherits(&JSSVGMatrix::s_info) ? (AffineTransform) *static_cast<JSSVGMatrix*>(asObject(value))->impl() : AffineTransform();
}

}

#endif // ENABLE(SVG)
