/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_netlogon.h"

struct rpccli_netr_LogonUasLogon_state {
	struct netr_LogonUasLogon orig;
	struct netr_LogonUasLogon tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonUasLogon_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonUasLogon_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_server_name /* [in] [unique,charset(UTF16)] */,
						  const char *_account_name /* [in] [ref,charset(UTF16)] */,
						  const char *_workstation /* [in] [ref,charset(UTF16)] */,
						  struct netr_UasInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonUasLogon_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonUasLogon_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.workstation = _workstation;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonUasLogon_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONUASLOGON,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonUasLogon_done, req);
	return req;
}

static void rpccli_netr_LogonUasLogon_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonUasLogon_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonUasLogon_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonUasLogon_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct rpccli_netr_LogonUasLogon_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonUasLogon_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonUasLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name /* [in] [unique,charset(UTF16)] */,
				   const char *account_name /* [in] [ref,charset(UTF16)] */,
				   const char *workstation /* [in] [ref,charset(UTF16)] */,
				   struct netr_UasInfo **info /* [out] [ref] */,
				   WERROR *werror)
{
	struct netr_LogonUasLogon r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.workstation = workstation;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONUASLOGON,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonUasLogoff_state {
	struct netr_LogonUasLogoff orig;
	struct netr_LogonUasLogoff tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonUasLogoff_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonUasLogoff_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_server_name /* [in] [unique,charset(UTF16)] */,
						   const char *_account_name /* [in] [ref,charset(UTF16)] */,
						   const char *_workstation /* [in] [ref,charset(UTF16)] */,
						   struct netr_UasLogoffInfo *_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonUasLogoff_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonUasLogoff_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.workstation = _workstation;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonUasLogoff_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONUASLOGOFF,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonUasLogoff_done, req);
	return req;
}

static void rpccli_netr_LogonUasLogoff_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonUasLogoff_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonUasLogoff_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonUasLogoff_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct rpccli_netr_LogonUasLogoff_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonUasLogoff_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonUasLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name /* [in] [unique,charset(UTF16)] */,
				    const char *account_name /* [in] [ref,charset(UTF16)] */,
				    const char *workstation /* [in] [ref,charset(UTF16)] */,
				    struct netr_UasLogoffInfo *info /* [out] [ref] */,
				    WERROR *werror)
{
	struct netr_LogonUasLogoff r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.workstation = workstation;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONUASLOGOFF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonSamLogon_state {
	struct netr_LogonSamLogon orig;
	struct netr_LogonSamLogon tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonSamLogon_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonSamLogon_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_server_name /* [in] [unique,charset(UTF16)] */,
						  const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						  struct netr_Authenticator *_credential /* [in] [unique] */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
						  enum netr_LogonInfoClass _logon_level /* [in]  */,
						  union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
						  uint16_t _validation_level /* [in]  */,
						  union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
						  uint8_t *_authoritative /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonSamLogon_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonSamLogon_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.logon_level = _logon_level;
	state->orig.in.logon = _logon;
	state->orig.in.validation_level = _validation_level;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.validation = _validation;
	state->orig.out.authoritative = _authoritative;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonSamLogon_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONSAMLOGON,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonSamLogon_done, req);
	return req;
}

static void rpccli_netr_LogonSamLogon_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonSamLogon_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonSamLogon_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.return_authenticator && state->tmp.out.return_authenticator) {
		*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	}
	*state->orig.out.validation = *state->tmp.out.validation;
	*state->orig.out.authoritative = *state->tmp.out.authoritative;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonSamLogon_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct rpccli_netr_LogonSamLogon_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonSamLogon_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonSamLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name /* [in] [unique,charset(UTF16)] */,
				   const char *computer_name /* [in] [unique,charset(UTF16)] */,
				   struct netr_Authenticator *credential /* [in] [unique] */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
				   enum netr_LogonInfoClass logon_level /* [in]  */,
				   union netr_LogonLevel *logon /* [in] [ref,switch_is(logon_level)] */,
				   uint16_t validation_level /* [in]  */,
				   union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
				   uint8_t *authoritative /* [out] [ref] */)
{
	struct netr_LogonSamLogon r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.logon_level = logon_level;
	r.in.logon = logon;
	r.in.validation_level = validation_level;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONSAMLOGON,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (return_authenticator && r.out.return_authenticator) {
		*return_authenticator = *r.out.return_authenticator;
	}
	*validation = *r.out.validation;
	*authoritative = *r.out.authoritative;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_LogonSamLogoff_state {
	struct netr_LogonSamLogoff orig;
	struct netr_LogonSamLogoff tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonSamLogoff_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonSamLogoff_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_server_name /* [in] [unique,charset(UTF16)] */,
						   const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						   struct netr_Authenticator *_credential /* [in] [unique] */,
						   struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
						   enum netr_LogonInfoClass _logon_level /* [in]  */,
						   union netr_LogonLevel _logon /* [in] [switch_is(logon_level)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonSamLogoff_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonSamLogoff_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.logon_level = _logon_level;
	state->orig.in.logon = _logon;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonSamLogoff_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONSAMLOGOFF,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonSamLogoff_done, req);
	return req;
}

static void rpccli_netr_LogonSamLogoff_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonSamLogoff_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonSamLogoff_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.return_authenticator && state->tmp.out.return_authenticator) {
		*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonSamLogoff_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct rpccli_netr_LogonSamLogoff_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonSamLogoff_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonSamLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name /* [in] [unique,charset(UTF16)] */,
				    const char *computer_name /* [in] [unique,charset(UTF16)] */,
				    struct netr_Authenticator *credential /* [in] [unique] */,
				    struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
				    enum netr_LogonInfoClass logon_level /* [in]  */,
				    union netr_LogonLevel logon /* [in] [switch_is(logon_level)] */)
{
	struct netr_LogonSamLogoff r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.logon_level = logon_level;
	r.in.logon = logon;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONSAMLOGOFF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (return_authenticator && r.out.return_authenticator) {
		*return_authenticator = *r.out.return_authenticator;
	}

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_ServerReqChallenge_state {
	struct netr_ServerReqChallenge orig;
	struct netr_ServerReqChallenge tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerReqChallenge_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerReqChallenge_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [unique,charset(UTF16)] */,
						       const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						       struct netr_Credential *_credentials /* [in] [ref] */,
						       struct netr_Credential *_return_credentials /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerReqChallenge_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerReqChallenge_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credentials = _credentials;

	/* Out parameters */
	state->orig.out.return_credentials = _return_credentials;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerReqChallenge_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERREQCHALLENGE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerReqChallenge_done, req);
	return req;
}

static void rpccli_netr_ServerReqChallenge_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerReqChallenge_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerReqChallenge_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_credentials = *state->tmp.out.return_credentials;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerReqChallenge_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_netr_ServerReqChallenge_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerReqChallenge_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerReqChallenge(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *computer_name /* [in] [ref,charset(UTF16)] */,
					struct netr_Credential *credentials /* [in] [ref] */,
					struct netr_Credential *return_credentials /* [out] [ref] */)
{
	struct netr_ServerReqChallenge r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credentials = credentials;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERREQCHALLENGE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_credentials = *r.out.return_credentials;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_ServerAuthenticate_state {
	struct netr_ServerAuthenticate orig;
	struct netr_ServerAuthenticate tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerAuthenticate_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerAuthenticate_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [unique,charset(UTF16)] */,
						       const char *_account_name /* [in] [ref,charset(UTF16)] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						       struct netr_Credential *_credentials /* [in] [ref] */,
						       struct netr_Credential *_return_credentials /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerAuthenticate_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerAuthenticate_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credentials = _credentials;

	/* Out parameters */
	state->orig.out.return_credentials = _return_credentials;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerAuthenticate_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERAUTHENTICATE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerAuthenticate_done, req);
	return req;
}

static void rpccli_netr_ServerAuthenticate_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerAuthenticate_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerAuthenticate_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_credentials = *state->tmp.out.return_credentials;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerAuthenticate_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_netr_ServerAuthenticate_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerAuthenticate_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerAuthenticate(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [ref,charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [ref,charset(UTF16)] */,
					struct netr_Credential *credentials /* [in] [ref] */,
					struct netr_Credential *return_credentials /* [out] [ref] */)
{
	struct netr_ServerAuthenticate r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credentials = credentials;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERAUTHENTICATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_credentials = *r.out.return_credentials;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_ServerPasswordSet_state {
	struct netr_ServerPasswordSet orig;
	struct netr_ServerPasswordSet tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerPasswordSet_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerPasswordSet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      const char *_server_name /* [in] [unique,charset(UTF16)] */,
						      const char *_account_name /* [in] [ref,charset(UTF16)] */,
						      enum netr_SchannelType _secure_channel_type /* [in]  */,
						      const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						      struct netr_Authenticator *_credential /* [in] [ref] */,
						      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						      struct samr_Password *_new_password /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerPasswordSet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerPasswordSet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.new_password = _new_password;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerPasswordSet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERPASSWORDSET,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerPasswordSet_done, req);
	return req;
}

static void rpccli_netr_ServerPasswordSet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerPasswordSet_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerPasswordSet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerPasswordSet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_netr_ServerPasswordSet_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerPasswordSet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerPasswordSet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name /* [in] [unique,charset(UTF16)] */,
				       const char *account_name /* [in] [ref,charset(UTF16)] */,
				       enum netr_SchannelType secure_channel_type /* [in]  */,
				       const char *computer_name /* [in] [ref,charset(UTF16)] */,
				       struct netr_Authenticator *credential /* [in] [ref] */,
				       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
				       struct samr_Password *new_password /* [in] [ref] */)
{
	struct netr_ServerPasswordSet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.new_password = new_password;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERPASSWORDSET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_DatabaseDeltas_state {
	struct netr_DatabaseDeltas orig;
	struct netr_DatabaseDeltas tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DatabaseDeltas_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DatabaseDeltas_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_logon_server /* [in] [ref,charset(UTF16)] */,
						   const char *_computername /* [in] [ref,charset(UTF16)] */,
						   struct netr_Authenticator *_credential /* [in] [ref] */,
						   struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						   enum netr_SamDatabaseID _database_id /* [in]  */,
						   uint64_t *_sequence_num /* [in,out] [ref] */,
						   struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						   uint32_t _preferredmaximumlength /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_netr_DatabaseDeltas_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DatabaseDeltas_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.database_id = _database_id;
	state->orig.in.sequence_num = _sequence_num;
	state->orig.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.sequence_num = _sequence_num;
	state->orig.out.delta_enum_array = _delta_enum_array;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DatabaseDeltas_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DATABASEDELTAS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DatabaseDeltas_done, req);
	return req;
}

static void rpccli_netr_DatabaseDeltas_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DatabaseDeltas_state *state = tevent_req_data(
		req, struct rpccli_netr_DatabaseDeltas_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.sequence_num = *state->tmp.out.sequence_num;
	*state->orig.out.delta_enum_array = *state->tmp.out.delta_enum_array;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DatabaseDeltas_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct rpccli_netr_DatabaseDeltas_state *state = tevent_req_data(
		req, struct rpccli_netr_DatabaseDeltas_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DatabaseDeltas(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *logon_server /* [in] [ref,charset(UTF16)] */,
				    const char *computername /* [in] [ref,charset(UTF16)] */,
				    struct netr_Authenticator *credential /* [in] [ref] */,
				    struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				    enum netr_SamDatabaseID database_id /* [in]  */,
				    uint64_t *sequence_num /* [in,out] [ref] */,
				    struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				    uint32_t preferredmaximumlength /* [in]  */)
{
	struct netr_DatabaseDeltas r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.database_id = database_id;
	r.in.sequence_num = sequence_num;
	r.in.preferredmaximumlength = preferredmaximumlength;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DATABASEDELTAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*sequence_num = *r.out.sequence_num;
	*delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_DatabaseSync_state {
	struct netr_DatabaseSync orig;
	struct netr_DatabaseSync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DatabaseSync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DatabaseSync_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_logon_server /* [in] [ref,charset(UTF16)] */,
						 const char *_computername /* [in] [ref,charset(UTF16)] */,
						 struct netr_Authenticator *_credential /* [in] [ref] */,
						 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						 enum netr_SamDatabaseID _database_id /* [in]  */,
						 uint32_t *_sync_context /* [in,out] [ref] */,
						 struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						 uint32_t _preferredmaximumlength /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_netr_DatabaseSync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DatabaseSync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.database_id = _database_id;
	state->orig.in.sync_context = _sync_context;
	state->orig.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.sync_context = _sync_context;
	state->orig.out.delta_enum_array = _delta_enum_array;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DatabaseSync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DATABASESYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DatabaseSync_done, req);
	return req;
}

static void rpccli_netr_DatabaseSync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DatabaseSync_state *state = tevent_req_data(
		req, struct rpccli_netr_DatabaseSync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.sync_context = *state->tmp.out.sync_context;
	*state->orig.out.delta_enum_array = *state->tmp.out.delta_enum_array;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DatabaseSync_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_netr_DatabaseSync_state *state = tevent_req_data(
		req, struct rpccli_netr_DatabaseSync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DatabaseSync(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [ref,charset(UTF16)] */,
				  const char *computername /* [in] [ref,charset(UTF16)] */,
				  struct netr_Authenticator *credential /* [in] [ref] */,
				  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				  enum netr_SamDatabaseID database_id /* [in]  */,
				  uint32_t *sync_context /* [in,out] [ref] */,
				  struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				  uint32_t preferredmaximumlength /* [in]  */)
{
	struct netr_DatabaseSync r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.database_id = database_id;
	r.in.sync_context = sync_context;
	r.in.preferredmaximumlength = preferredmaximumlength;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DATABASESYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*sync_context = *r.out.sync_context;
	*delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_AccountDeltas_state {
	struct netr_AccountDeltas orig;
	struct netr_AccountDeltas tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_AccountDeltas_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_AccountDeltas_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						  const char *_computername /* [in] [ref,charset(UTF16)] */,
						  struct netr_Authenticator _credential /* [in]  */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						  struct netr_UAS_INFO_0 _uas /* [in]  */,
						  uint32_t _count /* [in]  */,
						  uint32_t _level /* [in]  */,
						  uint32_t _buffersize /* [in]  */,
						  struct netr_AccountBuffer *_buffer /* [out] [ref,subcontext(4)] */,
						  uint32_t *_count_returned /* [out] [ref] */,
						  uint32_t *_total_entries /* [out] [ref] */,
						  struct netr_UAS_INFO_0 *_recordid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_AccountDeltas_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_AccountDeltas_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.uas = _uas;
	state->orig.in.count = _count;
	state->orig.in.level = _level;
	state->orig.in.buffersize = _buffersize;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.buffer = _buffer;
	state->orig.out.count_returned = _count_returned;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.recordid = _recordid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_AccountDeltas_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_ACCOUNTDELTAS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_AccountDeltas_done, req);
	return req;
}

static void rpccli_netr_AccountDeltas_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_AccountDeltas_state *state = tevent_req_data(
		req, struct rpccli_netr_AccountDeltas_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.count_returned = *state->tmp.out.count_returned;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.recordid = *state->tmp.out.recordid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_AccountDeltas_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct rpccli_netr_AccountDeltas_state *state = tevent_req_data(
		req, struct rpccli_netr_AccountDeltas_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_AccountDeltas(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [unique,charset(UTF16)] */,
				   const char *computername /* [in] [ref,charset(UTF16)] */,
				   struct netr_Authenticator credential /* [in]  */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				   struct netr_UAS_INFO_0 uas /* [in]  */,
				   uint32_t count /* [in]  */,
				   uint32_t level /* [in]  */,
				   uint32_t buffersize /* [in]  */,
				   struct netr_AccountBuffer *buffer /* [out] [ref,subcontext(4)] */,
				   uint32_t *count_returned /* [out] [ref] */,
				   uint32_t *total_entries /* [out] [ref] */,
				   struct netr_UAS_INFO_0 *recordid /* [out] [ref] */)
{
	struct netr_AccountDeltas r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.uas = uas;
	r.in.count = count;
	r.in.level = level;
	r.in.buffersize = buffersize;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_ACCOUNTDELTAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*buffer = *r.out.buffer;
	*count_returned = *r.out.count_returned;
	*total_entries = *r.out.total_entries;
	*recordid = *r.out.recordid;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_AccountSync_state {
	struct netr_AccountSync orig;
	struct netr_AccountSync tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_AccountSync_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_AccountSync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						const char *_computername /* [in] [ref,charset(UTF16)] */,
						struct netr_Authenticator _credential /* [in]  */,
						struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						uint32_t _reference /* [in]  */,
						uint32_t _level /* [in]  */,
						uint32_t _buffersize /* [in]  */,
						struct netr_AccountBuffer *_buffer /* [out] [ref,subcontext(4)] */,
						uint32_t *_count_returned /* [out] [ref] */,
						uint32_t *_total_entries /* [out] [ref] */,
						uint32_t *_next_reference /* [out] [ref] */,
						struct netr_UAS_INFO_0 *_recordid /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_AccountSync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_AccountSync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.reference = _reference;
	state->orig.in.level = _level;
	state->orig.in.buffersize = _buffersize;
	state->orig.in.recordid = _recordid;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.buffer = _buffer;
	state->orig.out.count_returned = _count_returned;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.next_reference = _next_reference;
	state->orig.out.recordid = _recordid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_AccountSync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_ACCOUNTSYNC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_AccountSync_done, req);
	return req;
}

static void rpccli_netr_AccountSync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_AccountSync_state *state = tevent_req_data(
		req, struct rpccli_netr_AccountSync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.count_returned = *state->tmp.out.count_returned;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.next_reference = *state->tmp.out.next_reference;
	*state->orig.out.recordid = *state->tmp.out.recordid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_AccountSync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_netr_AccountSync_state *state = tevent_req_data(
		req, struct rpccli_netr_AccountSync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_AccountSync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *logon_server /* [in] [unique,charset(UTF16)] */,
				 const char *computername /* [in] [ref,charset(UTF16)] */,
				 struct netr_Authenticator credential /* [in]  */,
				 struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				 uint32_t reference /* [in]  */,
				 uint32_t level /* [in]  */,
				 uint32_t buffersize /* [in]  */,
				 struct netr_AccountBuffer *buffer /* [out] [ref,subcontext(4)] */,
				 uint32_t *count_returned /* [out] [ref] */,
				 uint32_t *total_entries /* [out] [ref] */,
				 uint32_t *next_reference /* [out] [ref] */,
				 struct netr_UAS_INFO_0 *recordid /* [in,out] [ref] */)
{
	struct netr_AccountSync r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.reference = reference;
	r.in.level = level;
	r.in.buffersize = buffersize;
	r.in.recordid = recordid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_ACCOUNTSYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*buffer = *r.out.buffer;
	*count_returned = *r.out.count_returned;
	*total_entries = *r.out.total_entries;
	*next_reference = *r.out.next_reference;
	*recordid = *r.out.recordid;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_GetDcName_state {
	struct netr_GetDcName orig;
	struct netr_GetDcName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_GetDcName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_GetDcName_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      const char *_logon_server /* [in] [ref,charset(UTF16)] */,
					      const char *_domainname /* [in] [unique,charset(UTF16)] */,
					      const char **_dcname /* [out] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_GetDcName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_GetDcName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.domainname = _domainname;

	/* Out parameters */
	state->orig.out.dcname = _dcname;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_GetDcName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_GETDCNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_GetDcName_done, req);
	return req;
}

static void rpccli_netr_GetDcName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_GetDcName_state *state = tevent_req_data(
		req, struct rpccli_netr_GetDcName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dcname = *state->tmp.out.dcname;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_GetDcName_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct rpccli_netr_GetDcName_state *state = tevent_req_data(
		req, struct rpccli_netr_GetDcName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_GetDcName(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       const char *logon_server /* [in] [ref,charset(UTF16)] */,
			       const char *domainname /* [in] [unique,charset(UTF16)] */,
			       const char **dcname /* [out] [ref,charset(UTF16)] */,
			       WERROR *werror)
{
	struct netr_GetDcName r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.domainname = domainname;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_GETDCNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*dcname = *r.out.dcname;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonControl_state {
	struct netr_LogonControl orig;
	struct netr_LogonControl tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonControl_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonControl_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						 enum netr_LogonControlCode _function_code /* [in]  */,
						 uint32_t _level /* [in]  */,
						 union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.function_code = _function_code;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.query = _query;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONCONTROL,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonControl_done, req);
	return req;
}

static void rpccli_netr_LogonControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonControl_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonControl_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_netr_LogonControl_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonControl(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [unique,charset(UTF16)] */,
				  enum netr_LogonControlCode function_code /* [in]  */,
				  uint32_t level /* [in]  */,
				  union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				  WERROR *werror)
{
	struct netr_LogonControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.function_code = function_code;
	r.in.level = level;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONCONTROL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*query = *r.out.query;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_GetAnyDCName_state {
	struct netr_GetAnyDCName orig;
	struct netr_GetAnyDCName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_GetAnyDCName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_GetAnyDCName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						 const char *_domainname /* [in] [unique,charset(UTF16)] */,
						 const char **_dcname /* [out] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_GetAnyDCName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_GetAnyDCName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.domainname = _domainname;

	/* Out parameters */
	state->orig.out.dcname = _dcname;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_GetAnyDCName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_GETANYDCNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_GetAnyDCName_done, req);
	return req;
}

static void rpccli_netr_GetAnyDCName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_GetAnyDCName_state *state = tevent_req_data(
		req, struct rpccli_netr_GetAnyDCName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dcname = *state->tmp.out.dcname;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_GetAnyDCName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_netr_GetAnyDCName_state *state = tevent_req_data(
		req, struct rpccli_netr_GetAnyDCName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_GetAnyDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [unique,charset(UTF16)] */,
				  const char *domainname /* [in] [unique,charset(UTF16)] */,
				  const char **dcname /* [out] [ref,charset(UTF16)] */,
				  WERROR *werror)
{
	struct netr_GetAnyDCName r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.domainname = domainname;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_GETANYDCNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*dcname = *r.out.dcname;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonControl2_state {
	struct netr_LogonControl2 orig;
	struct netr_LogonControl2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonControl2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonControl2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						  enum netr_LogonControlCode _function_code /* [in]  */,
						  uint32_t _level /* [in]  */,
						  union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
						  union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonControl2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonControl2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.function_code = _function_code;
	state->orig.in.level = _level;
	state->orig.in.data = _data;

	/* Out parameters */
	state->orig.out.query = _query;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonControl2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONCONTROL2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonControl2_done, req);
	return req;
}

static void rpccli_netr_LogonControl2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonControl2_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonControl2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonControl2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct rpccli_netr_LogonControl2_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonControl2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonControl2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [unique,charset(UTF16)] */,
				   enum netr_LogonControlCode function_code /* [in]  */,
				   uint32_t level /* [in]  */,
				   union netr_CONTROL_DATA_INFORMATION *data /* [in] [ref,switch_is(function_code)] */,
				   union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				   WERROR *werror)
{
	struct netr_LogonControl2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.function_code = function_code;
	r.in.level = level;
	r.in.data = data;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONCONTROL2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*query = *r.out.query;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_ServerAuthenticate2_state {
	struct netr_ServerAuthenticate2 orig;
	struct netr_ServerAuthenticate2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerAuthenticate2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerAuthenticate2_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							const char *_server_name /* [in] [unique,charset(UTF16)] */,
							const char *_account_name /* [in] [ref,charset(UTF16)] */,
							enum netr_SchannelType _secure_channel_type /* [in]  */,
							const char *_computer_name /* [in] [ref,charset(UTF16)] */,
							struct netr_Credential *_credentials /* [in] [ref] */,
							struct netr_Credential *_return_credentials /* [out] [ref] */,
							uint32_t *_negotiate_flags /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerAuthenticate2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerAuthenticate2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credentials = _credentials;
	state->orig.in.negotiate_flags = _negotiate_flags;

	/* Out parameters */
	state->orig.out.return_credentials = _return_credentials;
	state->orig.out.negotiate_flags = _negotiate_flags;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerAuthenticate2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERAUTHENTICATE2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerAuthenticate2_done, req);
	return req;
}

static void rpccli_netr_ServerAuthenticate2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerAuthenticate2_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerAuthenticate2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_credentials = *state->tmp.out.return_credentials;
	*state->orig.out.negotiate_flags = *state->tmp.out.negotiate_flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerAuthenticate2_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_netr_ServerAuthenticate2_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerAuthenticate2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerAuthenticate2(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [unique,charset(UTF16)] */,
					 const char *account_name /* [in] [ref,charset(UTF16)] */,
					 enum netr_SchannelType secure_channel_type /* [in]  */,
					 const char *computer_name /* [in] [ref,charset(UTF16)] */,
					 struct netr_Credential *credentials /* [in] [ref] */,
					 struct netr_Credential *return_credentials /* [out] [ref] */,
					 uint32_t *negotiate_flags /* [in,out] [ref] */)
{
	struct netr_ServerAuthenticate2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credentials = credentials;
	r.in.negotiate_flags = negotiate_flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERAUTHENTICATE2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_credentials = *r.out.return_credentials;
	*negotiate_flags = *r.out.negotiate_flags;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_DatabaseSync2_state {
	struct netr_DatabaseSync2 orig;
	struct netr_DatabaseSync2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DatabaseSync2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DatabaseSync2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_logon_server /* [in] [ref,charset(UTF16)] */,
						  const char *_computername /* [in] [ref,charset(UTF16)] */,
						  struct netr_Authenticator *_credential /* [in] [ref] */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						  enum netr_SamDatabaseID _database_id /* [in]  */,
						  enum SyncStateEnum _restart_state /* [in]  */,
						  uint32_t *_sync_context /* [in,out] [ref] */,
						  struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						  uint32_t _preferredmaximumlength /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_netr_DatabaseSync2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DatabaseSync2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.database_id = _database_id;
	state->orig.in.restart_state = _restart_state;
	state->orig.in.sync_context = _sync_context;
	state->orig.in.preferredmaximumlength = _preferredmaximumlength;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.sync_context = _sync_context;
	state->orig.out.delta_enum_array = _delta_enum_array;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DatabaseSync2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DATABASESYNC2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DatabaseSync2_done, req);
	return req;
}

static void rpccli_netr_DatabaseSync2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DatabaseSync2_state *state = tevent_req_data(
		req, struct rpccli_netr_DatabaseSync2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.sync_context = *state->tmp.out.sync_context;
	*state->orig.out.delta_enum_array = *state->tmp.out.delta_enum_array;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DatabaseSync2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct rpccli_netr_DatabaseSync2_state *state = tevent_req_data(
		req, struct rpccli_netr_DatabaseSync2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DatabaseSync2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [ref,charset(UTF16)] */,
				   const char *computername /* [in] [ref,charset(UTF16)] */,
				   struct netr_Authenticator *credential /* [in] [ref] */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				   enum netr_SamDatabaseID database_id /* [in]  */,
				   enum SyncStateEnum restart_state /* [in]  */,
				   uint32_t *sync_context /* [in,out] [ref] */,
				   struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				   uint32_t preferredmaximumlength /* [in]  */)
{
	struct netr_DatabaseSync2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.database_id = database_id;
	r.in.restart_state = restart_state;
	r.in.sync_context = sync_context;
	r.in.preferredmaximumlength = preferredmaximumlength;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DATABASESYNC2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*sync_context = *r.out.sync_context;
	*delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_DatabaseRedo_state {
	struct netr_DatabaseRedo orig;
	struct netr_DatabaseRedo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DatabaseRedo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DatabaseRedo_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_logon_server /* [in] [ref,charset(UTF16)] */,
						 const char *_computername /* [in] [ref,charset(UTF16)] */,
						 struct netr_Authenticator *_credential /* [in] [ref] */,
						 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						 struct netr_ChangeLogEntry _change_log_entry /* [in] [subcontext_size(change_log_entry_size),subcontext(4)] */,
						 uint32_t _change_log_entry_size /* [in] [value(ndr_size_netr_ChangeLogEntry(&change_log_entry,ndr->iconv_convenience,ndr->flags))] */,
						 struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DatabaseRedo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DatabaseRedo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.computername = _computername;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.change_log_entry = _change_log_entry;
	state->orig.in.change_log_entry_size = _change_log_entry_size;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.delta_enum_array = _delta_enum_array;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DatabaseRedo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DATABASEREDO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DatabaseRedo_done, req);
	return req;
}

static void rpccli_netr_DatabaseRedo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DatabaseRedo_state *state = tevent_req_data(
		req, struct rpccli_netr_DatabaseRedo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.delta_enum_array = *state->tmp.out.delta_enum_array;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DatabaseRedo_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_netr_DatabaseRedo_state *state = tevent_req_data(
		req, struct rpccli_netr_DatabaseRedo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DatabaseRedo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [ref,charset(UTF16)] */,
				  const char *computername /* [in] [ref,charset(UTF16)] */,
				  struct netr_Authenticator *credential /* [in] [ref] */,
				  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				  struct netr_ChangeLogEntry change_log_entry /* [in] [subcontext_size(change_log_entry_size),subcontext(4)] */,
				  uint32_t change_log_entry_size /* [in] [value(ndr_size_netr_ChangeLogEntry(&change_log_entry,ndr->iconv_convenience,ndr->flags))] */,
				  struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */)
{
	struct netr_DatabaseRedo r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.change_log_entry = change_log_entry;
	r.in.change_log_entry_size = change_log_entry_size;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DATABASEREDO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_LogonControl2Ex_state {
	struct netr_LogonControl2Ex orig;
	struct netr_LogonControl2Ex tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonControl2Ex_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonControl2Ex_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						    enum netr_LogonControlCode _function_code /* [in]  */,
						    uint32_t _level /* [in]  */,
						    union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
						    union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonControl2Ex_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonControl2Ex_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.logon_server = _logon_server;
	state->orig.in.function_code = _function_code;
	state->orig.in.level = _level;
	state->orig.in.data = _data;

	/* Out parameters */
	state->orig.out.query = _query;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonControl2Ex_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONCONTROL2EX,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonControl2Ex_done, req);
	return req;
}

static void rpccli_netr_LogonControl2Ex_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonControl2Ex_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonControl2Ex_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonControl2Ex_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_netr_LogonControl2Ex_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonControl2Ex_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonControl2Ex(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *logon_server /* [in] [unique,charset(UTF16)] */,
				     enum netr_LogonControlCode function_code /* [in]  */,
				     uint32_t level /* [in]  */,
				     union netr_CONTROL_DATA_INFORMATION *data /* [in] [ref,switch_is(function_code)] */,
				     union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				     WERROR *werror)
{
	struct netr_LogonControl2Ex r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.function_code = function_code;
	r.in.level = level;
	r.in.data = data;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONCONTROL2EX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*query = *r.out.query;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_NetrEnumerateTrustedDomains_state {
	struct netr_NetrEnumerateTrustedDomains orig;
	struct netr_NetrEnumerateTrustedDomains tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_NetrEnumerateTrustedDomains_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_NetrEnumerateTrustedDomains_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli,
								const char *_server_name /* [in] [unique,charset(UTF16)] */,
								struct netr_Blob *_trusted_domains_blob /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_NetrEnumerateTrustedDomains_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_NetrEnumerateTrustedDomains_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */
	state->orig.out.trusted_domains_blob = _trusted_domains_blob;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_NetrEnumerateTrustedDomains_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_NETRENUMERATETRUSTEDDOMAINS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_NetrEnumerateTrustedDomains_done, req);
	return req;
}

static void rpccli_netr_NetrEnumerateTrustedDomains_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_NetrEnumerateTrustedDomains_state *state = tevent_req_data(
		req, struct rpccli_netr_NetrEnumerateTrustedDomains_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trusted_domains_blob = *state->tmp.out.trusted_domains_blob;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_NetrEnumerateTrustedDomains_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct rpccli_netr_NetrEnumerateTrustedDomains_state *state = tevent_req_data(
		req, struct rpccli_netr_NetrEnumerateTrustedDomains_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_NetrEnumerateTrustedDomains(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name /* [in] [unique,charset(UTF16)] */,
						 struct netr_Blob *trusted_domains_blob /* [out] [ref] */,
						 WERROR *werror)
{
	struct netr_NetrEnumerateTrustedDomains r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRENUMERATETRUSTEDDOMAINS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trusted_domains_blob = *r.out.trusted_domains_blob;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_DsRGetDCName_state {
	struct netr_DsRGetDCName orig;
	struct netr_DsRGetDCName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsRGetDCName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsRGetDCName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *_domain_name /* [in] [unique,charset(UTF16)] */,
						 struct GUID *_domain_guid /* [in] [unique] */,
						 struct GUID *_site_guid /* [in] [unique] */,
						 uint32_t _flags /* [in]  */,
						 struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsRGetDCName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsRGetDCName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_guid = _site_guid;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsRGetDCName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRGETDCNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsRGetDCName_done, req);
	return req;
}

static void rpccli_netr_DsRGetDCName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsRGetDCName_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetDCName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsRGetDCName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_netr_DsRGetDCName_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetDCName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsRGetDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *server_unc /* [in] [unique,charset(UTF16)] */,
				  const char *domain_name /* [in] [unique,charset(UTF16)] */,
				  struct GUID *domain_guid /* [in] [unique] */,
				  struct GUID *site_guid /* [in] [unique] */,
				  uint32_t flags /* [in]  */,
				  struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				  WERROR *werror)
{
	struct netr_DsRGetDCName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.domain_name = domain_name;
	r.in.domain_guid = domain_guid;
	r.in.site_guid = site_guid;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETDCNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonGetCapabilities_state {
	struct netr_LogonGetCapabilities orig;
	struct netr_LogonGetCapabilities tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonGetCapabilities_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonGetCapabilities_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 const char *_server_name /* [in] [ref,charset(UTF16)] */,
							 const char *_computer_name /* [in] [unique,charset(UTF16)] */,
							 struct netr_Authenticator *_credential /* [in] [ref] */,
							 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
							 uint32_t _query_level /* [in]  */,
							 union netr_Capabilities *_capabilities /* [out] [ref,switch_is(query_level)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonGetCapabilities_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonGetCapabilities_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.query_level = _query_level;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.capabilities = _capabilities;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonGetCapabilities_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONGETCAPABILITIES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonGetCapabilities_done, req);
	return req;
}

static void rpccli_netr_LogonGetCapabilities_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonGetCapabilities_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonGetCapabilities_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.capabilities = *state->tmp.out.capabilities;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonGetCapabilities_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct rpccli_netr_LogonGetCapabilities_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonGetCapabilities_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonGetCapabilities(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_name /* [in] [ref,charset(UTF16)] */,
					  const char *computer_name /* [in] [unique,charset(UTF16)] */,
					  struct netr_Authenticator *credential /* [in] [ref] */,
					  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
					  uint32_t query_level /* [in]  */,
					  union netr_Capabilities *capabilities /* [out] [ref,switch_is(query_level)] */)
{
	struct netr_LogonGetCapabilities r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.query_level = query_level;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONGETCAPABILITIES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*capabilities = *r.out.capabilities;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_NETRLOGONSETSERVICEBITS_state {
	struct netr_NETRLOGONSETSERVICEBITS orig;
	struct netr_NETRLOGONSETSERVICEBITS tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_NETRLOGONSETSERVICEBITS_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_NETRLOGONSETSERVICEBITS_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_netr_NETRLOGONSETSERVICEBITS_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_NETRLOGONSETSERVICEBITS_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_NETRLOGONSETSERVICEBITS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_NETRLOGONSETSERVICEBITS_done, req);
	return req;
}

static void rpccli_netr_NETRLOGONSETSERVICEBITS_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_NETRLOGONSETSERVICEBITS_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONSETSERVICEBITS_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_NETRLOGONSETSERVICEBITS_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct rpccli_netr_NETRLOGONSETSERVICEBITS_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONSETSERVICEBITS_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_NETRLOGONSETSERVICEBITS(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror)
{
	struct netr_NETRLOGONSETSERVICEBITS r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONSETSERVICEBITS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonGetTrustRid_state {
	struct netr_LogonGetTrustRid orig;
	struct netr_LogonGetTrustRid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonGetTrustRid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonGetTrustRid_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     const char *_server_name /* [in] [unique,charset(UTF16)] */,
						     const char *_domain_name /* [in] [unique,charset(UTF16)] */,
						     uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonGetTrustRid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonGetTrustRid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;

	/* Out parameters */
	state->orig.out.rid = _rid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonGetTrustRid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONGETTRUSTRID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonGetTrustRid_done, req);
	return req;
}

static void rpccli_netr_LogonGetTrustRid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonGetTrustRid_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonGetTrustRid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonGetTrustRid_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct rpccli_netr_LogonGetTrustRid_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonGetTrustRid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonGetTrustRid(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_name /* [in] [unique,charset(UTF16)] */,
				      const char *domain_name /* [in] [unique,charset(UTF16)] */,
				      uint32_t *rid /* [out] [ref] */,
				      WERROR *werror)
{
	struct netr_LogonGetTrustRid r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.domain_name = domain_name;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONGETTRUSTRID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rid = *r.out.rid;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_state {
	struct netr_NETRLOGONCOMPUTESERVERDIGEST orig;
	struct netr_NETRLOGONCOMPUTESERVERDIGEST tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_NETRLOGONCOMPUTESERVERDIGEST,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_done, req);
	return req;
}

static void rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror)
{
	struct netr_NETRLOGONCOMPUTESERVERDIGEST r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONCOMPUTESERVERDIGEST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_state {
	struct netr_NETRLOGONCOMPUTECLIENTDIGEST orig;
	struct netr_NETRLOGONCOMPUTECLIENTDIGEST tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_NETRLOGONCOMPUTECLIENTDIGEST,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_done, req);
	return req;
}

static void rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror)
{
	struct netr_NETRLOGONCOMPUTECLIENTDIGEST r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONCOMPUTECLIENTDIGEST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_ServerAuthenticate3_state {
	struct netr_ServerAuthenticate3 orig;
	struct netr_ServerAuthenticate3 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerAuthenticate3_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerAuthenticate3_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							const char *_server_name /* [in] [unique,charset(UTF16)] */,
							const char *_account_name /* [in] [ref,charset(UTF16)] */,
							enum netr_SchannelType _secure_channel_type /* [in]  */,
							const char *_computer_name /* [in] [ref,charset(UTF16)] */,
							struct netr_Credential *_credentials /* [in] [ref] */,
							struct netr_Credential *_return_credentials /* [out] [ref] */,
							uint32_t *_negotiate_flags /* [in,out] [ref] */,
							uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerAuthenticate3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerAuthenticate3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credentials = _credentials;
	state->orig.in.negotiate_flags = _negotiate_flags;

	/* Out parameters */
	state->orig.out.return_credentials = _return_credentials;
	state->orig.out.negotiate_flags = _negotiate_flags;
	state->orig.out.rid = _rid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerAuthenticate3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERAUTHENTICATE3,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerAuthenticate3_done, req);
	return req;
}

static void rpccli_netr_ServerAuthenticate3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerAuthenticate3_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerAuthenticate3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_credentials = *state->tmp.out.return_credentials;
	*state->orig.out.negotiate_flags = *state->tmp.out.negotiate_flags;
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerAuthenticate3_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_netr_ServerAuthenticate3_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerAuthenticate3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerAuthenticate3(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [unique,charset(UTF16)] */,
					 const char *account_name /* [in] [ref,charset(UTF16)] */,
					 enum netr_SchannelType secure_channel_type /* [in]  */,
					 const char *computer_name /* [in] [ref,charset(UTF16)] */,
					 struct netr_Credential *credentials /* [in] [ref] */,
					 struct netr_Credential *return_credentials /* [out] [ref] */,
					 uint32_t *negotiate_flags /* [in,out] [ref] */,
					 uint32_t *rid /* [out] [ref] */)
{
	struct netr_ServerAuthenticate3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credentials = credentials;
	r.in.negotiate_flags = negotiate_flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERAUTHENTICATE3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_credentials = *r.out.return_credentials;
	*negotiate_flags = *r.out.negotiate_flags;
	*rid = *r.out.rid;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_DsRGetDCNameEx_state {
	struct netr_DsRGetDCNameEx orig;
	struct netr_DsRGetDCNameEx tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsRGetDCNameEx_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsRGetDCNameEx_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						   const char *_domain_name /* [in] [unique,charset(UTF16)] */,
						   struct GUID *_domain_guid /* [in] [unique] */,
						   const char *_site_name /* [in] [unique,charset(UTF16)] */,
						   uint32_t _flags /* [in]  */,
						   struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsRGetDCNameEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsRGetDCNameEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_name = _site_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsRGetDCNameEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRGETDCNAMEEX,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsRGetDCNameEx_done, req);
	return req;
}

static void rpccli_netr_DsRGetDCNameEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsRGetDCNameEx_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetDCNameEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsRGetDCNameEx_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct rpccli_netr_DsRGetDCNameEx_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetDCNameEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsRGetDCNameEx(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    const char *domain_name /* [in] [unique,charset(UTF16)] */,
				    struct GUID *domain_guid /* [in] [unique] */,
				    const char *site_name /* [in] [unique,charset(UTF16)] */,
				    uint32_t flags /* [in]  */,
				    struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				    WERROR *werror)
{
	struct netr_DsRGetDCNameEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.domain_name = domain_name;
	r.in.domain_guid = domain_guid;
	r.in.site_name = site_name;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETDCNAMEEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_DsRGetSiteName_state {
	struct netr_DsRGetSiteName orig;
	struct netr_DsRGetSiteName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsRGetSiteName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsRGetSiteName_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						   const char **_site /* [out] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsRGetSiteName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsRGetSiteName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.computer_name = _computer_name;

	/* Out parameters */
	state->orig.out.site = _site;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsRGetSiteName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRGETSITENAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsRGetSiteName_done, req);
	return req;
}

static void rpccli_netr_DsRGetSiteName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsRGetSiteName_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetSiteName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.site = *state->tmp.out.site;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsRGetSiteName_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct rpccli_netr_DsRGetSiteName_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetSiteName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsRGetSiteName(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *computer_name /* [in] [unique,charset(UTF16)] */,
				    const char **site /* [out] [ref,charset(UTF16)] */,
				    WERROR *werror)
{
	struct netr_DsRGetSiteName r;
	NTSTATUS status;

	/* In parameters */
	r.in.computer_name = computer_name;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETSITENAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*site = *r.out.site;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonGetDomainInfo_state {
	struct netr_LogonGetDomainInfo orig;
	struct netr_LogonGetDomainInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonGetDomainInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonGetDomainInfo_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [ref,charset(UTF16)] */,
						       const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						       uint32_t _level /* [in]  */,
						       union netr_WorkstationInfo *_query /* [in] [ref,switch_is(level)] */,
						       union netr_DomainInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonGetDomainInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonGetDomainInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.level = _level;
	state->orig.in.query = _query;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonGetDomainInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONGETDOMAININFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonGetDomainInfo_done, req);
	return req;
}

static void rpccli_netr_LogonGetDomainInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonGetDomainInfo_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonGetDomainInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonGetDomainInfo_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_netr_LogonGetDomainInfo_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonGetDomainInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonGetDomainInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [ref,charset(UTF16)] */,
					const char *computer_name /* [in] [unique,charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
					uint32_t level /* [in]  */,
					union netr_WorkstationInfo *query /* [in] [ref,switch_is(level)] */,
					union netr_DomainInfo *info /* [out] [ref,switch_is(level)] */)
{
	struct netr_LogonGetDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.level = level;
	r.in.query = query;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONGETDOMAININFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_ServerPasswordSet2_state {
	struct netr_ServerPasswordSet2 orig;
	struct netr_ServerPasswordSet2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerPasswordSet2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerPasswordSet2_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [unique,charset(UTF16)] */,
						       const char *_account_name /* [in] [ref,charset(UTF16)] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						       struct netr_CryptPassword *_new_password /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerPasswordSet2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerPasswordSet2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.new_password = _new_password;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerPasswordSet2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERPASSWORDSET2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerPasswordSet2_done, req);
	return req;
}

static void rpccli_netr_ServerPasswordSet2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerPasswordSet2_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerPasswordSet2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerPasswordSet2_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_netr_ServerPasswordSet2_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerPasswordSet2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerPasswordSet2(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [ref,charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [ref,charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					struct netr_CryptPassword *new_password /* [in] [ref] */)
{
	struct netr_ServerPasswordSet2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.new_password = new_password;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERPASSWORDSET2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_ServerPasswordGet_state {
	struct netr_ServerPasswordGet orig;
	struct netr_ServerPasswordGet tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerPasswordGet_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerPasswordGet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      const char *_server_name /* [in] [unique,charset(UTF16)] */,
						      const char *_account_name /* [in] [ref,charset(UTF16)] */,
						      enum netr_SchannelType _secure_channel_type /* [in]  */,
						      const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						      struct netr_Authenticator *_credential /* [in] [ref] */,
						      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						      struct samr_Password *_password /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerPasswordGet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerPasswordGet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.password = _password;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerPasswordGet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERPASSWORDGET,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerPasswordGet_done, req);
	return req;
}

static void rpccli_netr_ServerPasswordGet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerPasswordGet_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerPasswordGet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.password = *state->tmp.out.password;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerPasswordGet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct rpccli_netr_ServerPasswordGet_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerPasswordGet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerPasswordGet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name /* [in] [unique,charset(UTF16)] */,
				       const char *account_name /* [in] [ref,charset(UTF16)] */,
				       enum netr_SchannelType secure_channel_type /* [in]  */,
				       const char *computer_name /* [in] [ref,charset(UTF16)] */,
				       struct netr_Authenticator *credential /* [in] [ref] */,
				       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
				       struct samr_Password *password /* [out] [ref] */,
				       WERROR *werror)
{
	struct netr_ServerPasswordGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERPASSWORDGET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*password = *r.out.password;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_NETRLOGONSENDTOSAM_state {
	struct netr_NETRLOGONSENDTOSAM orig;
	struct netr_NETRLOGONSENDTOSAM tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_NETRLOGONSENDTOSAM_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_NETRLOGONSENDTOSAM_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_netr_NETRLOGONSENDTOSAM_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_NETRLOGONSENDTOSAM_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_NETRLOGONSENDTOSAM,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_NETRLOGONSENDTOSAM_done, req);
	return req;
}

static void rpccli_netr_NETRLOGONSENDTOSAM_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_NETRLOGONSENDTOSAM_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONSENDTOSAM_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_NETRLOGONSENDTOSAM_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct rpccli_netr_NETRLOGONSENDTOSAM_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONSENDTOSAM_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_NETRLOGONSENDTOSAM(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct netr_NETRLOGONSENDTOSAM r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONSENDTOSAM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_DsRAddressToSitenamesW_state {
	struct netr_DsRAddressToSitenamesW orig;
	struct netr_DsRAddressToSitenamesW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsRAddressToSitenamesW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsRAddressToSitenamesW_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   const char *_server_name /* [in] [unique,charset(UTF16)] */,
							   uint32_t _count /* [in] [range(0,32000)] */,
							   struct netr_DsRAddress *_addresses /* [in] [ref,size_is(count)] */,
							   struct netr_DsRAddressToSitenamesWCtr **_ctr /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsRAddressToSitenamesW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsRAddressToSitenamesW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.count = _count;
	state->orig.in.addresses = _addresses;

	/* Out parameters */
	state->orig.out.ctr = _ctr;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsRAddressToSitenamesW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRADDRESSTOSITENAMESW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsRAddressToSitenamesW_done, req);
	return req;
}

static void rpccli_netr_DsRAddressToSitenamesW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsRAddressToSitenamesW_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRAddressToSitenamesW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsRAddressToSitenamesW_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct rpccli_netr_DsRAddressToSitenamesW_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRAddressToSitenamesW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsRAddressToSitenamesW(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name /* [in] [unique,charset(UTF16)] */,
					    uint32_t count /* [in] [range(0,32000)] */,
					    struct netr_DsRAddress *addresses /* [in] [ref,size_is(count)] */,
					    struct netr_DsRAddressToSitenamesWCtr **ctr /* [out] [ref] */,
					    WERROR *werror)
{
	struct netr_DsRAddressToSitenamesW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.count = count;
	r.in.addresses = addresses;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRADDRESSTOSITENAMESW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_DsRGetDCNameEx2_state {
	struct netr_DsRGetDCNameEx2 orig;
	struct netr_DsRGetDCNameEx2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsRGetDCNameEx2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsRGetDCNameEx2_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						    const char *_client_account /* [in] [unique,charset(UTF16)] */,
						    uint32_t _mask /* [in]  */,
						    const char *_domain_name /* [in] [unique,charset(UTF16)] */,
						    struct GUID *_domain_guid /* [in] [unique] */,
						    const char *_site_name /* [in] [unique,charset(UTF16)] */,
						    uint32_t _flags /* [in]  */,
						    struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsRGetDCNameEx2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsRGetDCNameEx2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.client_account = _client_account;
	state->orig.in.mask = _mask;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_name = _site_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsRGetDCNameEx2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRGETDCNAMEEX2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsRGetDCNameEx2_done, req);
	return req;
}

static void rpccli_netr_DsRGetDCNameEx2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsRGetDCNameEx2_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetDCNameEx2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsRGetDCNameEx2_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_netr_DsRGetDCNameEx2_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetDCNameEx2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsRGetDCNameEx2(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     const char *client_account /* [in] [unique,charset(UTF16)] */,
				     uint32_t mask /* [in]  */,
				     const char *domain_name /* [in] [unique,charset(UTF16)] */,
				     struct GUID *domain_guid /* [in] [unique] */,
				     const char *site_name /* [in] [unique,charset(UTF16)] */,
				     uint32_t flags /* [in]  */,
				     struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				     WERROR *werror)
{
	struct netr_DsRGetDCNameEx2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.client_account = client_account;
	r.in.mask = mask;
	r.in.domain_name = domain_name;
	r.in.domain_guid = domain_guid;
	r.in.site_name = site_name;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETDCNAMEEX2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_state {
	struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN orig;
	struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_NETRLOGONGETTIMESERVICEPARENTDOMAIN,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_done, req);
	return req;
}

static void rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      WERROR *result)
{
	struct rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_state *state = tevent_req_data(
		req, struct rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct rpc_pipe_client *cli,
							 TALLOC_CTX *mem_ctx,
							 WERROR *werror)
{
	struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONGETTIMESERVICEPARENTDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_NetrEnumerateTrustedDomainsEx_state {
	struct netr_NetrEnumerateTrustedDomainsEx orig;
	struct netr_NetrEnumerateTrustedDomainsEx tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_NetrEnumerateTrustedDomainsEx_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_NetrEnumerateTrustedDomainsEx_send(TALLOC_CTX *mem_ctx,
								  struct tevent_context *ev,
								  struct rpc_pipe_client *cli,
								  const char *_server_name /* [in] [unique,charset(UTF16)] */,
								  struct netr_DomainTrustList *_dom_trust_list /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_NetrEnumerateTrustedDomainsEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_NetrEnumerateTrustedDomainsEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */
	state->orig.out.dom_trust_list = _dom_trust_list;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_NetrEnumerateTrustedDomainsEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_NETRENUMERATETRUSTEDDOMAINSEX,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_NetrEnumerateTrustedDomainsEx_done, req);
	return req;
}

static void rpccli_netr_NetrEnumerateTrustedDomainsEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_NetrEnumerateTrustedDomainsEx_state *state = tevent_req_data(
		req, struct rpccli_netr_NetrEnumerateTrustedDomainsEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dom_trust_list = *state->tmp.out.dom_trust_list;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_NetrEnumerateTrustedDomainsEx_recv(struct tevent_req *req,
							TALLOC_CTX *mem_ctx,
							WERROR *result)
{
	struct rpccli_netr_NetrEnumerateTrustedDomainsEx_state *state = tevent_req_data(
		req, struct rpccli_netr_NetrEnumerateTrustedDomainsEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_NetrEnumerateTrustedDomainsEx(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   const char *server_name /* [in] [unique,charset(UTF16)] */,
						   struct netr_DomainTrustList *dom_trust_list /* [out] [ref] */,
						   WERROR *werror)
{
	struct netr_NetrEnumerateTrustedDomainsEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRENUMERATETRUSTEDDOMAINSEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*dom_trust_list = *r.out.dom_trust_list;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_DsRAddressToSitenamesExW_state {
	struct netr_DsRAddressToSitenamesExW orig;
	struct netr_DsRAddressToSitenamesExW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsRAddressToSitenamesExW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsRAddressToSitenamesExW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     const char *_server_name /* [in] [unique,charset(UTF16)] */,
							     uint32_t _count /* [in] [range(0,32000)] */,
							     struct netr_DsRAddress *_addresses /* [in] [ref,size_is(count)] */,
							     struct netr_DsRAddressToSitenamesExWCtr **_ctr /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsRAddressToSitenamesExW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsRAddressToSitenamesExW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.count = _count;
	state->orig.in.addresses = _addresses;

	/* Out parameters */
	state->orig.out.ctr = _ctr;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsRAddressToSitenamesExW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRADDRESSTOSITENAMESEXW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsRAddressToSitenamesExW_done, req);
	return req;
}

static void rpccli_netr_DsRAddressToSitenamesExW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsRAddressToSitenamesExW_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRAddressToSitenamesExW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsRAddressToSitenamesExW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct rpccli_netr_DsRAddressToSitenamesExW_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRAddressToSitenamesExW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsRAddressToSitenamesExW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name /* [in] [unique,charset(UTF16)] */,
					      uint32_t count /* [in] [range(0,32000)] */,
					      struct netr_DsRAddress *addresses /* [in] [ref,size_is(count)] */,
					      struct netr_DsRAddressToSitenamesExWCtr **ctr /* [out] [ref] */,
					      WERROR *werror)
{
	struct netr_DsRAddressToSitenamesExW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.count = count;
	r.in.addresses = addresses;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRADDRESSTOSITENAMESEXW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_DsrGetDcSiteCoverageW_state {
	struct netr_DsrGetDcSiteCoverageW orig;
	struct netr_DsrGetDcSiteCoverageW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsrGetDcSiteCoverageW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsrGetDcSiteCoverageW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  const char *_server_name /* [in] [unique,charset(UTF16)] */,
							  struct DcSitesCtr **_ctr /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsrGetDcSiteCoverageW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsrGetDcSiteCoverageW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */
	state->orig.out.ctr = _ctr;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsrGetDcSiteCoverageW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRGETDCSITECOVERAGEW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsrGetDcSiteCoverageW_done, req);
	return req;
}

static void rpccli_netr_DsrGetDcSiteCoverageW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsrGetDcSiteCoverageW_state *state = tevent_req_data(
		req, struct rpccli_netr_DsrGetDcSiteCoverageW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsrGetDcSiteCoverageW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct rpccli_netr_DsrGetDcSiteCoverageW_state *state = tevent_req_data(
		req, struct rpccli_netr_DsrGetDcSiteCoverageW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsrGetDcSiteCoverageW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_name /* [in] [unique,charset(UTF16)] */,
					   struct DcSitesCtr **ctr /* [out] [ref] */,
					   WERROR *werror)
{
	struct netr_DsrGetDcSiteCoverageW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETDCSITECOVERAGEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonSamLogonEx_state {
	struct netr_LogonSamLogonEx orig;
	struct netr_LogonSamLogonEx tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonSamLogonEx_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonSamLogonEx_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_server_name /* [in] [unique,charset(UTF16)] */,
						    const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						    enum netr_LogonInfoClass _logon_level /* [in]  */,
						    union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
						    uint16_t _validation_level /* [in]  */,
						    union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
						    uint8_t *_authoritative /* [out] [ref] */,
						    uint32_t *_flags /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonSamLogonEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonSamLogonEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.logon_level = _logon_level;
	state->orig.in.logon = _logon;
	state->orig.in.validation_level = _validation_level;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.validation = _validation;
	state->orig.out.authoritative = _authoritative;
	state->orig.out.flags = _flags;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonSamLogonEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONSAMLOGONEX,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonSamLogonEx_done, req);
	return req;
}

static void rpccli_netr_LogonSamLogonEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonSamLogonEx_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonSamLogonEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.validation = *state->tmp.out.validation;
	*state->orig.out.authoritative = *state->tmp.out.authoritative;
	*state->orig.out.flags = *state->tmp.out.flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonSamLogonEx_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct rpccli_netr_LogonSamLogonEx_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonSamLogonEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonSamLogonEx(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_name /* [in] [unique,charset(UTF16)] */,
				     const char *computer_name /* [in] [unique,charset(UTF16)] */,
				     enum netr_LogonInfoClass logon_level /* [in]  */,
				     union netr_LogonLevel *logon /* [in] [ref,switch_is(logon_level)] */,
				     uint16_t validation_level /* [in]  */,
				     union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
				     uint8_t *authoritative /* [out] [ref] */,
				     uint32_t *flags /* [in,out] [ref] */)
{
	struct netr_LogonSamLogonEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.logon_level = logon_level;
	r.in.logon = logon;
	r.in.validation_level = validation_level;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONSAMLOGONEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*validation = *r.out.validation;
	*authoritative = *r.out.authoritative;
	*flags = *r.out.flags;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_DsrEnumerateDomainTrusts_state {
	struct netr_DsrEnumerateDomainTrusts orig;
	struct netr_DsrEnumerateDomainTrusts tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsrEnumerateDomainTrusts_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsrEnumerateDomainTrusts_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     const char *_server_name /* [in] [unique,charset(UTF16)] */,
							     uint32_t _trust_flags /* [in]  */,
							     struct netr_DomainTrustList *_trusts /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsrEnumerateDomainTrusts_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsrEnumerateDomainTrusts_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.trust_flags = _trust_flags;

	/* Out parameters */
	state->orig.out.trusts = _trusts;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsrEnumerateDomainTrusts_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRENUMERATEDOMAINTRUSTS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsrEnumerateDomainTrusts_done, req);
	return req;
}

static void rpccli_netr_DsrEnumerateDomainTrusts_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsrEnumerateDomainTrusts_state *state = tevent_req_data(
		req, struct rpccli_netr_DsrEnumerateDomainTrusts_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trusts = *state->tmp.out.trusts;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsrEnumerateDomainTrusts_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct rpccli_netr_DsrEnumerateDomainTrusts_state *state = tevent_req_data(
		req, struct rpccli_netr_DsrEnumerateDomainTrusts_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsrEnumerateDomainTrusts(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name /* [in] [unique,charset(UTF16)] */,
					      uint32_t trust_flags /* [in]  */,
					      struct netr_DomainTrustList *trusts /* [out] [ref] */,
					      WERROR *werror)
{
	struct netr_DsrEnumerateDomainTrusts r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.trust_flags = trust_flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRENUMERATEDOMAINTRUSTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trusts = *r.out.trusts;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_DsrDeregisterDNSHostRecords_state {
	struct netr_DsrDeregisterDNSHostRecords orig;
	struct netr_DsrDeregisterDNSHostRecords tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsrDeregisterDNSHostRecords_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsrDeregisterDNSHostRecords_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli,
								const char *_server_name /* [in] [unique,charset(UTF16)] */,
								const char *_domain /* [in] [unique,charset(UTF16)] */,
								struct GUID *_domain_guid /* [in] [unique] */,
								struct GUID *_dsa_guid /* [in] [unique] */,
								const char *_dns_host /* [in] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsrDeregisterDNSHostRecords_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsrDeregisterDNSHostRecords_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain = _domain;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.dsa_guid = _dsa_guid;
	state->orig.in.dns_host = _dns_host;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRDEREGISTERDNSHOSTRECORDS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsrDeregisterDNSHostRecords_done, req);
	return req;
}

static void rpccli_netr_DsrDeregisterDNSHostRecords_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsrDeregisterDNSHostRecords_state *state = tevent_req_data(
		req, struct rpccli_netr_DsrDeregisterDNSHostRecords_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsrDeregisterDNSHostRecords_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct rpccli_netr_DsrDeregisterDNSHostRecords_state *state = tevent_req_data(
		req, struct rpccli_netr_DsrDeregisterDNSHostRecords_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsrDeregisterDNSHostRecords(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name /* [in] [unique,charset(UTF16)] */,
						 const char *domain /* [in] [unique,charset(UTF16)] */,
						 struct GUID *domain_guid /* [in] [unique] */,
						 struct GUID *dsa_guid /* [in] [unique] */,
						 const char *dns_host /* [in] [ref,charset(UTF16)] */,
						 WERROR *werror)
{
	struct netr_DsrDeregisterDNSHostRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.domain = domain;
	r.in.domain_guid = domain_guid;
	r.in.dsa_guid = dsa_guid;
	r.in.dns_host = dns_host;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRDEREGISTERDNSHOSTRECORDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_ServerTrustPasswordsGet_state {
	struct netr_ServerTrustPasswordsGet orig;
	struct netr_ServerTrustPasswordsGet tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerTrustPasswordsGet_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerTrustPasswordsGet_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    const char *_server_name /* [in] [unique,charset(UTF16)] */,
							    const char *_account_name /* [in] [ref,charset(UTF16)] */,
							    enum netr_SchannelType _secure_channel_type /* [in]  */,
							    const char *_computer_name /* [in] [ref,charset(UTF16)] */,
							    struct netr_Authenticator *_credential /* [in] [ref] */,
							    struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
							    struct samr_Password *_password /* [out] [ref] */,
							    struct samr_Password *_password2 /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerTrustPasswordsGet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerTrustPasswordsGet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.password = _password;
	state->orig.out.password2 = _password2;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerTrustPasswordsGet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERTRUSTPASSWORDSGET,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerTrustPasswordsGet_done, req);
	return req;
}

static void rpccli_netr_ServerTrustPasswordsGet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerTrustPasswordsGet_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerTrustPasswordsGet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.password = *state->tmp.out.password;
	*state->orig.out.password2 = *state->tmp.out.password2;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerTrustPasswordsGet_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  NTSTATUS *result)
{
	struct rpccli_netr_ServerTrustPasswordsGet_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerTrustPasswordsGet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerTrustPasswordsGet(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     const char *server_name /* [in] [unique,charset(UTF16)] */,
					     const char *account_name /* [in] [ref,charset(UTF16)] */,
					     enum netr_SchannelType secure_channel_type /* [in]  */,
					     const char *computer_name /* [in] [ref,charset(UTF16)] */,
					     struct netr_Authenticator *credential /* [in] [ref] */,
					     struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					     struct samr_Password *password /* [out] [ref] */,
					     struct samr_Password *password2 /* [out] [ref] */)
{
	struct netr_ServerTrustPasswordsGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERTRUSTPASSWORDSGET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*password = *r.out.password;
	*password2 = *r.out.password2;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_DsRGetForestTrustInformation_state {
	struct netr_DsRGetForestTrustInformation orig;
	struct netr_DsRGetForestTrustInformation tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_DsRGetForestTrustInformation_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_DsRGetForestTrustInformation_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli,
								 const char *_server_name /* [in] [unique,charset(UTF16)] */,
								 const char *_trusted_domain_name /* [in] [unique,charset(UTF16)] */,
								 uint32_t _flags /* [in]  */,
								 struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_DsRGetForestTrustInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_DsRGetForestTrustInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.forest_trust_info = _forest_trust_info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_DsRGetForestTrustInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_DSRGETFORESTTRUSTINFORMATION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_DsRGetForestTrustInformation_done, req);
	return req;
}

static void rpccli_netr_DsRGetForestTrustInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_DsRGetForestTrustInformation_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetForestTrustInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.forest_trust_info = *state->tmp.out.forest_trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_DsRGetForestTrustInformation_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct rpccli_netr_DsRGetForestTrustInformation_state *state = tevent_req_data(
		req, struct rpccli_netr_DsRGetForestTrustInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_DsRGetForestTrustInformation(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  const char *server_name /* [in] [unique,charset(UTF16)] */,
						  const char *trusted_domain_name /* [in] [unique,charset(UTF16)] */,
						  uint32_t flags /* [in]  */,
						  struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */,
						  WERROR *werror)
{
	struct netr_DsRGetForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.trusted_domain_name = trusted_domain_name;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETFORESTTRUSTINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_GetForestTrustInformation_state {
	struct netr_GetForestTrustInformation orig;
	struct netr_GetForestTrustInformation tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_GetForestTrustInformation_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_GetForestTrustInformation_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli,
							      const char *_server_name /* [in] [unique,charset(UTF16)] */,
							      const char *_trusted_domain_name /* [in] [ref,charset(UTF16)] */,
							      struct netr_Authenticator *_credential /* [in] [ref] */,
							      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
							      uint32_t _flags /* [in]  */,
							      struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_GetForestTrustInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_GetForestTrustInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.credential = _credential;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.forest_trust_info = _forest_trust_info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_GetForestTrustInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_GETFORESTTRUSTINFORMATION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_GetForestTrustInformation_done, req);
	return req;
}

static void rpccli_netr_GetForestTrustInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_GetForestTrustInformation_state *state = tevent_req_data(
		req, struct rpccli_netr_GetForestTrustInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.forest_trust_info = *state->tmp.out.forest_trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_GetForestTrustInformation_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct rpccli_netr_GetForestTrustInformation_state *state = tevent_req_data(
		req, struct rpccli_netr_GetForestTrustInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_GetForestTrustInformation(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *server_name /* [in] [unique,charset(UTF16)] */,
					       const char *trusted_domain_name /* [in] [ref,charset(UTF16)] */,
					       struct netr_Authenticator *credential /* [in] [ref] */,
					       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					       uint32_t flags /* [in]  */,
					       struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */,
					       WERROR *werror)
{
	struct netr_GetForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.trusted_domain_name = trusted_domain_name;
	r.in.credential = credential;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_GETFORESTTRUSTINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_netr_LogonSamLogonWithFlags_state {
	struct netr_LogonSamLogonWithFlags orig;
	struct netr_LogonSamLogonWithFlags tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_LogonSamLogonWithFlags_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_LogonSamLogonWithFlags_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   const char *_server_name /* [in] [unique,charset(UTF16)] */,
							   const char *_computer_name /* [in] [unique,charset(UTF16)] */,
							   struct netr_Authenticator *_credential /* [in] [unique] */,
							   struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
							   enum netr_LogonInfoClass _logon_level /* [in]  */,
							   union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
							   uint16_t _validation_level /* [in]  */,
							   union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
							   uint8_t *_authoritative /* [out] [ref] */,
							   uint32_t *_flags /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_LogonSamLogonWithFlags_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_LogonSamLogonWithFlags_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;
	state->orig.in.return_authenticator = _return_authenticator;
	state->orig.in.logon_level = _logon_level;
	state->orig.in.logon = _logon;
	state->orig.in.validation_level = _validation_level;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.validation = _validation;
	state->orig.out.authoritative = _authoritative;
	state->orig.out.flags = _flags;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_LogonSamLogonWithFlags_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_LOGONSAMLOGONWITHFLAGS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_LogonSamLogonWithFlags_done, req);
	return req;
}

static void rpccli_netr_LogonSamLogonWithFlags_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_LogonSamLogonWithFlags_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonSamLogonWithFlags_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.return_authenticator && state->tmp.out.return_authenticator) {
		*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	}
	*state->orig.out.validation = *state->tmp.out.validation;
	*state->orig.out.authoritative = *state->tmp.out.authoritative;
	*state->orig.out.flags = *state->tmp.out.flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_LogonSamLogonWithFlags_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result)
{
	struct rpccli_netr_LogonSamLogonWithFlags_state *state = tevent_req_data(
		req, struct rpccli_netr_LogonSamLogonWithFlags_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_LogonSamLogonWithFlags(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name /* [in] [unique,charset(UTF16)] */,
					    const char *computer_name /* [in] [unique,charset(UTF16)] */,
					    struct netr_Authenticator *credential /* [in] [unique] */,
					    struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
					    enum netr_LogonInfoClass logon_level /* [in]  */,
					    union netr_LogonLevel *logon /* [in] [ref,switch_is(logon_level)] */,
					    uint16_t validation_level /* [in]  */,
					    union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
					    uint8_t *authoritative /* [out] [ref] */,
					    uint32_t *flags /* [in,out] [ref] */)
{
	struct netr_LogonSamLogonWithFlags r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.logon_level = logon_level;
	r.in.logon = logon;
	r.in.validation_level = validation_level;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONSAMLOGONWITHFLAGS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (return_authenticator && r.out.return_authenticator) {
		*return_authenticator = *r.out.return_authenticator;
	}
	*validation = *r.out.validation;
	*authoritative = *r.out.authoritative;
	*flags = *r.out.flags;

	/* Return result */
	return r.out.result;
}

struct rpccli_netr_ServerGetTrustInfo_state {
	struct netr_ServerGetTrustInfo orig;
	struct netr_ServerGetTrustInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_netr_ServerGetTrustInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_netr_ServerGetTrustInfo_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [unique,charset(UTF16)] */,
						       const char *_account_name /* [in] [ref,charset(UTF16)] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						       struct samr_Password *_new_owf_password /* [out] [ref] */,
						       struct samr_Password *_old_owf_password /* [out] [ref] */,
						       struct netr_TrustInfo **_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_netr_ServerGetTrustInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_netr_ServerGetTrustInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.secure_channel_type = _secure_channel_type;
	state->orig.in.computer_name = _computer_name;
	state->orig.in.credential = _credential;

	/* Out parameters */
	state->orig.out.return_authenticator = _return_authenticator;
	state->orig.out.new_owf_password = _new_owf_password;
	state->orig.out.old_owf_password = _old_owf_password;
	state->orig.out.trust_info = _trust_info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_netr_ServerGetTrustInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netlogon,
				    NDR_NETR_SERVERGETTRUSTINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_netr_ServerGetTrustInfo_done, req);
	return req;
}

static void rpccli_netr_ServerGetTrustInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_netr_ServerGetTrustInfo_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerGetTrustInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.return_authenticator = *state->tmp.out.return_authenticator;
	*state->orig.out.new_owf_password = *state->tmp.out.new_owf_password;
	*state->orig.out.old_owf_password = *state->tmp.out.old_owf_password;
	*state->orig.out.trust_info = *state->tmp.out.trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_netr_ServerGetTrustInfo_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_netr_ServerGetTrustInfo_state *state = tevent_req_data(
		req, struct rpccli_netr_ServerGetTrustInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_netr_ServerGetTrustInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [ref,charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [ref,charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					struct samr_Password *new_owf_password /* [out] [ref] */,
					struct samr_Password *old_owf_password /* [out] [ref] */,
					struct netr_TrustInfo **trust_info /* [out] [ref] */)
{
	struct netr_ServerGetTrustInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERGETTRUSTINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*new_owf_password = *r.out.new_owf_password;
	*old_owf_password = *r.out.old_owf_password;
	*trust_info = *r.out.trust_info;

	/* Return result */
	return r.out.result;
}

