//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano {
    using Soprano;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class Backend backend.h Soprano/Backend
    ///  \brief Soprano.Backend defines the interface for a Soprano backend plugin.
    ///  The Backend interface defines two important methods: createModel() and supportedFeatures().
    ///  It inherits from Error.ErrorCache for error handling and subclasses should use clearError()
    ///  and setError() to report the status.
    ///  \sa \ref soprano_writing_plugins
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///      </remarks>        <short>    \class Backend backend.</short>
    [SmokeClass("Soprano::Backend")]
    public abstract class Backend : Soprano.Plugin, Soprano.Error.IErrorCache {
        protected Backend(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Backend), this);
        }
        // Error lastError(); >>>> NOT CONVERTED
        // void setError(const Error& arg1); >>>> NOT CONVERTED
        public Backend(string name) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Backend$", "Backend(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Creates a new RDF model with options.
        ///  The caller takes ownership and has to care about deletion.
        ///  \param settings The settings that should be used to create the Model. Backend implementations
        ///  should never ignore settings but rather return 0 if an option is not supported. Backends can,
        ///  however, define their own default settings. Invalid settings should result in an Error with value
        ///  Error.ErrorInvalidArgument.
        ///  \sa BackendSetting
        ///          </remarks>        <short>    Creates a new RDF model with options.</short>
        [SmokeMethod("createModel(const QList<Soprano::BackendSetting>&) const")]
        public abstract Soprano.StorageModel CreateModel(List<Soprano.BackendSetting> settings);
        /// <remarks>
        ///  Phyically delete all data for a specific model. For most backends this means deleting some files
        ///  on the hard disk. With others it may mean to delete tables from an SQL database.
        ///  \param settings The settings that were used to create the model which should be deleted.
        ///                  For most backends the Soprano.BackendOptionStorageDir setting is probably most important.
        ///                  If the settings do not provide enough information to uniquely identify the model
        ///                  to delete, the method should be terminated with an Error.ErrorInvalidArgument
        ///                  error.
        ///  \return <pre>true</pre> if the data was successfully removed, <pre>false</pre> otherwise. ErrorCache.LastError()
        ///          may provide more detailed error information in the latter case.
        ///  \since 2.1
        ///          </remarks>        <short>    Phyically delete all data for a specific model.</short>
        [SmokeMethod("deleteModelData(const QList<Soprano::BackendSetting>&) const")]
        public abstract bool DeleteModelData(List<Soprano.BackendSetting> settings);
        /// <remarks>
        ///  Each backend can support a set of features. Backends without any features do not make much sense.
        ///  If the features include Soprano.BackendFeatureUser additional user features not defined in 
        ///  Backend.BackendFeature can be supported via supportedUserFeatures().
        ///  \return A combination of Soprano.BackendFeature values.
        ///          </remarks>        <short>    Each backend can support a set of features.</short>
        [SmokeMethod("supportedFeatures() const")]
        public abstract uint SupportedFeatures();
        /// <remarks>
        ///  A Backend can support additional features that are not defined in Backend.BackendFeature.
        ///  These user defined features have string identifiers. If a backend supports additional features
        ///  it has to include Soprano.BackendFeatureUser in supportedFeatures().
        ///  The default implementation returns an empty list.
        ///  \return the list of supported user features.
        ///          </remarks>        <short>    A Backend can support additional features that are not defined in Backend.BackendFeature.</short>
        [SmokeMethod("supportedUserFeatures() const")]
        public virtual List<string> SupportedUserFeatures() {
            return (List<string>) interceptor.Invoke("supportedUserFeatures", "supportedUserFeatures() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Check if a backend supports certain features. If feature includes Soprano.BackendFeatureUser
        ///  the list if userFeatures is also compared.
        ///  \return <pre>true</pre> if the backend does support the requested features, <pre>false</pre> otherwise.
        ///          </remarks>        <short>    Check if a backend supports certain features.</short>
        public bool SupportsFeatures(uint feature, List<string> userFeatures) {
            return (bool) interceptor.Invoke("supportsFeatures$?", "supportsFeatures(Soprano::BackendFeatures, const QStringList&) const", typeof(bool), typeof(uint), feature, typeof(List<string>), userFeatures);
        }
        public bool SupportsFeatures(uint feature) {
            return (bool) interceptor.Invoke("supportsFeatures$", "supportsFeatures(Soprano::BackendFeatures) const", typeof(bool), typeof(uint), feature);
        }
        /// <remarks>
        ///  Get the last error that occured in the current thread.
        ///              </remarks>        <short>    Get the last error that occured in the current thread.</short>
        /// <remarks>
        ///  Reset the error for the current thread to no error.
        ///              </remarks>        <short>    Reset the error for the current thread to no error.</short>
        protected void ClearError() {
            interceptor.Invoke("clearError", "clearError() const", typeof(void));
        }
        /// <remarks>
        ///  Set the last occured error. This method is const to allow setting
        ///  of errors in all types of methods. The last error is as such a 
        ///  mutable property.
        ///              </remarks>        <short>    Set the last occured error.</short>
        /// <remarks>
        ///  Convenience method to set simple string error messages with a default
        ///  error code ErrorUnknown.
        ///              </remarks>        <short>    Convenience method to set simple string error messages with a default  error code ErrorUnknown.</short>
        protected void SetError(string errorMessage, int code) {
            interceptor.Invoke("setError$$", "setError(const QString&, int) const", typeof(void), typeof(string), errorMessage, typeof(int), code);
        }
        protected void SetError(string errorMessage) {
            interceptor.Invoke("setError$", "setError(const QString&) const", typeof(void), typeof(string), errorMessage);
        }
    }
}
