#!/bin/sh
# Copyright (C) 1993-1995 Ian Jackson.

# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# It is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with GNU Emacs; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

# (Note: I do not consider works produced using these BFNN processing
# tools to be derivative works of the tools, so they are NOT covered
# by the GPL.  However, I would appreciate it if you credited me if
# appropriate in any documents you format using BFNN.)

set -e
export GZIP=-9vn

test -f linux-faq.info  || gunzip linux-faq.info
test -f linux-faq.ps    || gunzip linux-faq.ps
rm -f linux-faq.source.tar{,.sig,.gz}

tar -vvcf linux-faq.source.tar \
	bfnnconv.pl m-{ascii,info,lout,html,post}.pl \
	linux-faq.bfnn html.refs linux-faq.readmesrc changes.text \
	buildsend.sh mktar.sh expirydate expirydate2 expirydatecc
pgp-auto +batchmode +force -sab linux-faq.source.tar
cat linux-faq.readmesrc linux-faq.source.tar.asc >linux-faq.README
gzip -f linux-faq.{info,ps} linux-faq.source.tar
tar -zvvcf linux-faq.tar.gz \
	linux-faq.{README,ascii} linux-faq.{info,ps}.gz \
	linux-faq.source.tar.gz
ls -FCl linux-faq.tar.gz
tar -f linux-faq.html.tar.gz -C linux-faq.html -zvvc `ls -1 linux-faq.html`
ls -FCl linux-faq.html.tar.gz
