#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>
#include <pwd.h>
#include <sys/param.h>
#include <unistd.h>

#include "filemgr.h"
#include "debug.h"
extern char *base_dir;

#if defined __hpux || defined SYSV || defined SVR4
#define getwd(arg)      getcwd(arg, (size_t) MAXPATHLEN)
#endif


char *ExpandDirName(char *dir)
{
  char *home,*newdir;
  char *username;
  struct passwd *pwd_str;
  int i;

  if(dir[0] == '~')
    {
      /* expand "~" to home directory */
      home = getenv("HOME");
      if((dir[1] == '/')||(dir[1] == 0))
	{
	  newdir=(char *)safemalloc(strlen(home)+ strlen(&dir[1])+2,"newdir");
	  strcpy(newdir,home);
	  strcat(newdir,"/");
	  strcat(newdir,&dir[1]);
	  safefree(dir,"dir","b");
	  dir = newdir;
	}
      else
	{
	  username =(char *)safemalloc(strlen(&dir[1])+1,"username");
	  i =1;
	  while((dir[i] != '/')&&(dir[i] != 0))
	    {
	      username[i-1] =  dir[i];
	      i++;
	    }
	  if(i>1)
	    {
	      username[i-1] = 0;
	      pwd_str = getpwnam(username);
	      newdir = (char *)safemalloc(strlen(pwd_str->pw_dir)+ 
					  strlen(&dir[i])+2,"newdir");
	      strcpy(newdir,pwd_str->pw_dir);
	      strcat(newdir,&dir[i]);
	      safefree(username,"username","Expand");
	      safefree(dir,"dir","b");
	      dir = newdir;
	    }
	  else
	    {
	      safefree(username,"username","Expand2");
	    }
	}
    }
  
  if(chdir(dir)!=0)
    {
      safefree(dir,"NoDir","Expand");
      return NULL;
    }

  newdir = (char *)safemalloc(MAXPATHLEN+1,"newdir2");
  getwd(newdir);
  safefree(dir,"dir","b");
  dir = newdir;
  return dir;
}
