/* 'new' config.h:
 *	A configuration file designed to make best use of the abilities
 *	of ircII, and trying to make things more intuitively understandable.
 *
 * Done by Carl v. Loesch <lynx@dm.unirm1.it>
 * Based on the 'classic' config.h by Michael Sandrof.
 * Copyright(c) 1991 - See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * Warning!  You will most likely have to make changes to your .ircrc file to
 * use this version of IRCII!  Please read the INSTALL and New2.2 files
 * supplied with the distribution for details!
 *
 * @(#)$Id: config.h.dist,v 1.9.2.3 1995/11/01 13:16:23 mrg Exp $
 */

#ifndef __config_h_
#define __config_h_

/*
 * Set your favorite default server list here.  This list should be a
 * whitespace separated hostname:portnum:password list (with portnums and
 * passwords optional).  This IS NOT an optional definition. Please set this
 * to your nearest servers.  However if you use a seperate 'ircII.servers'
 * file and the ircII can find it, this setting is overridden.
 */

#ifndef DEFAULT_SERVER
#define DEFAULT_SERVER	    "[efnet] irc.cs.cmu.edu irc.visi.com irc.videotron.ab.ca irc.total.net:6660 [fefnet] raistlin.toledolink.com [efnet] irc.nwlink.com irc.nol.net irc.undernet.org::::undernet [other] anv2.myweb.net irc.is.a.badhabit.org"
#endif

/*
 * Define this if you want the $glob() function to be in your client.
 * There is a case for having this functino and a case against having
 * this function:
 *
 * Pro: makes it easier to write scripts like xdcc, since they can easily
 *      get at the filenames in your xdcc directory
 * Cons: with $unlink(), $rmdir(), etc, it makes it that much easier for
 *      a backdoor to do damage to your account.
 *
 * You will have to weigh the evidence and decide if you want to include it.
 */
#define INCLUDE_GLOB_FUNCTION

/*
 * Youll want to define this if your system is missing the glob()
 * call, or if its broken (solaris).
 *
 * Actually, you should #define this if you can compile the supplied
 * glob.c.  If it works, dont mess with it.
 */
#define NEED_GLOB

/*
 * Define this to be the number of seconds that you want the client
 * to block on a server-connection.  I found it annoying that it was
 * hard coded to 15 seconds, as that was never long enough to make
 * a connection.  Change it back if you want.
 *
 * This is ONLY for /server and 'server-like' connections, not for DCC.
 */
#define CONNECT_TIMEOUT 20

/*
 * I moved this here because it seemed to be the most appropriate
 * place for it.  Define this if you want support for ``/window create''
 * and its related features.  If you dont want it, youll save some code,
 * and you wont need 'wserv', and if you do want it, you can have it in
 * all of its broken glory (no, i dont have plans to fix it =)
 * window create doesn't make any sense on windows 95/nt
 */
#if !defined(WINNT) && !defined(__EMX__)
#define WINDOW_CREATE
#else
#undef WINDOW_CREATE
#endif

/*
 * Define this if you want an mIRC compatable /dcc resume capability.
 * Note that this BREAKS THE IRC PROTOCOL, and if you use this feature,
 * the behavior is NON COMPLIANT.  If this warning doesnt bother you,
 * and you really want this feature, then go ahead and #define this.
 */
#define MIRC_BROKEN_DCC_RESUME 1

/*
 * Set the following to 1 if you wish for IRCII not to disturb the tty's flow
 * control characters as the default.  Normally, these are ^Q and ^S.  You
 * may have to rebind them in IRCII.  Set it to 0 for IRCII to take over the
 * tty's flow control.
 */
#define USE_FLOW_CONTROL 1

/*
 * Uncomment the following if the gecos field of your /etc/passwd has other
 * information in it that you don't want as the user name (such as office
 * locations, phone numbers, etc).  The default delimiter is a comma, change
 * it if you need to. If commented out, the entire gecos field is used. 
 */
#define GECOS_DELIMITER ','

/*
 * MAIL_DELIMITER specifies the unique text that separates one mail message
 * from another in the mail spool file when using UNIX_MAIL.
 */
#define MAIL_DELIMITER "From "

/* Thanks to Allanon a very useful feature, when this is defined, ircII will
 * be able to read help files in compressed format (it will recognize the .Z)
 * If you undefine this you will spare some code, though, so better only
 * set if you are sure you are going to keep your help-files compressed.
 */
#define ZCAT "/bin/zcat"

/* Define ZSUFFIX in case we are using ZCAT */
#ifdef ZCAT
# define ZSUFFIX ".gz"
#endif

/* Make ^Z stop the irc process by default,
 * if undefined, ^Z will self-insert by default
 */
#define ALLOW_STOP_IRC /**/

/* And here is the port number for default client connections.  */
#define IRC_PORT 6667

/*
 * Uncomment the following to make ircII read a list of irc servers from
 * the ircII.servers file in the ircII library. This file should be
 * whitespace separated hostname:portnum:password (with the portnum and
 * password being optional). This server list will supercede the
 * DEFAULT_SERVER. 
*/
#if defined(WINNT) || defined(__EMX__)
#define SERVERS_FILE "irc-serv"
#else
#define SERVERS_FILE "ircII.servers"
#endif

/* If you define UNAME_HACK, the uname information displayed in the
 * CTCP VERSION info will appear as "*IX" irregardless of any other
 * settings.  Useful for paranoid users who dont want others to know
 * that theyre running a buggy SunOS machine. >;-)
 */
#undef UNAME_HACK

/* If you define ONLY_STD_CHARS, only "normal" characters will displayed.
 * This is recommended when you want to start BitchX in an xterm without
 * the usage of the special "vga"-font. 
 */
#undef ONLY_STD_CHARS

/*
 * Normally BitchX uses only the IBMPC (cp437) charset.
 * Define LATIN1, if you want to see the standard Latin1 characters
 * (i.e.        <-> "A "O "U "a "o "u \ss ).
 *
 * You will still be able to see ansi graphics, but there will be some
 * smaller problems (i.e. after a PageUp).
 *
 * If you use xterm there is no easy way to use both fonts at the same
 * time.  You have to decide if you use the standard (latin1) fonts or
 * vga.pcf (cp437).
 *
 * Is here there any solution to use both fonts nethertheless ?
 */

#undef LATIN1

#if defined LATIN1
/* Make sure the keyboard works */
#undef EMACS_KEYBINDS

/* No line chars available, so better define this: */
#define ONLY_STD_CHARS
#endif

/* 
 * If you want the non-ansi BitchX logo only define this ASCII_LOGO
 *
 * Note: On the console ansi graphics can be displayed just fine, even 
 * when you've defined LATIN1. The problem is that ansi graphics will look
 * ugly if you use the scroll up feature (PageUp/PageDown)
 */

#undef ASCII_LOGO


/* If you define REVERSE_WHITE_BLACK, then the format codes for black and
 * white color are reversed. (%W, %w is bold black and black, %K, %k is bold
 * white and white). This way the default format-strings are readable on
 * a display with white background and black foreground.
 */ 
#undef REVERSE_WHITE_BLACK

/*
 * Certain versions of Tcl lib have a PLUS version which preloads the scripts
 * into the binary so that the script directory is not required to run the 
 * tcllib. This offers some benefit at the expense of a slightly larger binary.
 */
#undef TCL_PLUS

/* if you use cidentd the filename is called .authlie instead of .noident.
 * as well some modifications to the format of the file were made. So we 
 * require some pre-knowledge of what to expect. WinNT identd servers will 
 * also require this.
 */
#define CIDENTD 1


/* define this if your using a hacked ident and want to fake your username.
 * maybe we could also use this to specify what file to write this hack to. 
 * Some examples are ~/.noident and ~/.authlie
 */
#define IDENT_FAKE 1

/*
 * This is the filename of the identd file to use
 */
#ifdef CIDENTD
#define DEFAULT_IDENT_HACK ".authlie"
#else
#define DEFAULT_IDENT_HACK ".noident"
#endif

/* On some channels mass modes can be confusing and in some case 
 * spectacular so in the interest of keeping sanity, Jordy added this 
 * mode compressor to the client. It reduces the duplicate modes that 
 * might occur on a channel.. it's explained in names.c much better.
 */
 #define COMPRESS_MODES

/* crisk graciously allowed me to include his hebrew modification to ircII
 * in the client. defining this variable to 1 allows that happen. It also
 * adds a HEBREW_TOGGLE variable which can turn this feature on/off
 */
#undef WANT_HEBREW
 
/*
 * we define the default network type for server groups. Do not just
 * undefine this.
 */
 #define DEFAULT_NETWORK "efnet"

/*
 * defining this enables translation to occur. You need a copy of the 
 * translation tables from ircII for this to work. Also enable /set TRANSLATE
 */
 
#undef TRANSLATE
#define TRANSLATION_PATH "/usr/local/lib/irc/translation"

/*
 * Below are the IRCII variable defaults.  For boolean variables, use 1 for
 * ON and 0 for OFF.  You may set string variable to NULL if you wish them to
 * have no value.  None of these are optional.  You may *not* comment out or
 * remove them.  They are default values for variables and are required for
 * proper compilation.
 */

#define DEFAULT_KICK_REASON "Bitch-X BaBy!"
#define DEFAULT_SHOW_CTCP_IDLE 1
#define DEFAULT_PING_TYPE 1
#define DEFAULT_MSGLOG 1

#if defined(WINNT) || defined(__EMX__)
#define DEFAULT_MSGLOGFILE "BitchX.awy"
#else
#define DEFAULT_MSGLOGFILE "BitchX.away"
#endif

#define DEFAULT_AUTO_NSLOOKUP 0
#define DEFAULT_REASON_TYPE 1
#define DEFAULT_FLOOD_KICK 1
#define DEFAULT_FLOOD_PROTECTION 1
#define DEFAULT_CTCP_FLOOD_PROTECTION 1
#define DEFAULT_PROTECT_CHANNELS "*"

#define DEFAULT_SHITLIST_REASON "Surplus Lamerz must go!!!!"
#define DEFAULT_MAX_AUTOGET_SIZE 2000000
#define DEFAULT_LLOOK_DELAY 120

#define DEFAULT_ALWAYS_SPLIT_BIGGEST 1
#define DEFAULT_AUTO_UNMARK_AWAY 0
#define DEFAULT_AUTO_WHOWAS 0
#define DEFAULT_BEEP 1
#define DEFAULT_BEEP_MAX 3
#define DEFAULT_BEEP_ON_MSG "MSGS"
#define DEFAULT_BEEP_WHEN_AWAY 0
#define DEFAULT_BOLD_VIDEO 1
#define DEFAULT_BLINK_VIDEO 1
#define DEFAULT_CHANNEL_NAME_WIDTH 10
#define DEFAULT_CLOCK 1
#define DEFAULT_CLOCK_24HOUR 0
#define DEFAULT_CMDCHARS "/"
#define DEFAULT_COMMAND_MODE 0
#define DEFAULT_COMMENT_HACK 1
#define DEFAULT_CONTINUED_LINE "          "
#define DEFAULT_DCC_BLOCK_SIZE 2048
#define DEFAULT_DISPLAY 1
#define DEFAULT_EIGHT_BIT_CHARACTERS 1
#define DEFAULT_EXEC_PROTECTION 1
#define DEFAULT_ENCRYPT_LOG 1
#define DEFAULT_FLOOD_AFTER 4
#define DEFAULT_FLOOD_RATE 5
#define DEFAULT_FLOOD_USERS 10
#define DEFAULT_FLOOD_WARNING 0
#define DEFAULT_FULL_STATUS_LINE 1
#define DEFAULT_HELP_PAGER 1
#define DEFAULT_HELP_PROMPT 1
#define DEFAULT_HIDE_PRIVATE_CHANNELS 0
#define DEFAULT_HIGHLIGHT_CHAR "INVERSE"
#define DEFAULT_HISTORY 100
#define DEFAULT_HOLD_MODE 0
#define DEFAULT_HOLD_MODE_MAX 0
#define DEFAULT_INDENT 1
#define DEFAULT_INPUT_ALIASES 0

#define DEFAULT_INPUT_PROMPT "[$C] "

#define DEFAULT_INPUT_PROTECTION 0
#define DEFAULT_INSERT_MODE 1
#define DEFAULT_INVERSE_VIDEO 1
#define DEFAULT_LASTLOG 1000
#define DEFAULT_LASTLOG_LEVEL "ALL"
#define DEFAULT_MSGLOG_LEVEL "MSGS NOTICES SEND_MSG"

#define DEFAULT_LOG 0
#define DEFAULT_LOGFILE "IrcLog"
#define DEFAULT_MAIL 2
#define DEFAULT_MAX_RECURSIONS 10
#define DEFAULT_NO_CTCP_FLOOD 1
#define DEFAULT_NOTIFY_HANDLER "QUIET"
#define DEFAULT_NOTIFY_LEVEL "ALL DCC"
#define DEFAULT_NOTIFY_ON_TERMINATION 0
#define DEFAULT_SCROLL_LINES 1
#define DEFAULT_SEND_IGNORE_MSG 0
#define DEFAULT_SHELL "/bin/sh"
#define DEFAULT_SHELL_FLAGS "-c"
#define DEFAULT_SHELL_LIMIT 0
#define DEFAULT_SHOW_AWAY_ONCE 1
#define DEFAULT_SHOW_CHANNEL_NAMES 1
#define DEFAULT_SHOW_END_OF_MSGS 0
#define DEFAULT_SHOW_NUMERICS 0
#define DEFAULT_SHOW_STATUS_ALL 0
#define DEFAULT_SHOW_WHO_HOPCOUNT 0



#define DEFAULT_STATUS_FORMAT " [0;44;36m[[1;37m%T[0;44;36m][%@[0;44;37m%N%#%A[0;44;36m]%M [0;44;36m[%=%C%+%W[0;44;36m] %Q %H%B%F "
#define DEFAULT_STATUS_FORMAT1 " [0;44;36m[[1;37m%T[0;44;36m][[1;37m%@[0;44;37m%N%#%A[0;44;36m]%M [0;44;36m[%=%C%+%W[0;44;36m] %Q %H%B%F "
#define DEFAULT_STATUS_FORMAT2 " %L %! %K %>%D %J[%u:%a:%f:%b:%h]"
#define DEFAULT_STATUS_FORMAT3 "BitchX by panasync "

#define DEFAULT_STATUS_AWAY " [0;44;36m([1;32mzZzZ[1;37m %A[0;44;36m)[0;44;37m"
#define DEFAULT_STATUS_CHANNEL "[0;44;37m%C"
#define DEFAULT_STATUS_CHANOP "@"
#define DEFAULT_STATUS_CLOCK "%T"
#define DEFAULT_STATUS_HOLD " -- more --"
#define DEFAULT_STATUS_HOLD_LINES " [0;44;36m([1;37m%B[0;44m)[0;44;37m"
#define DEFAULT_STATUS_INSERT ""
#define DEFAULT_STATUS_LAG "[0;44;36m[[0;44;37mLag [1;37m%L[0;44;36m]"
#define DEFAULT_STATUS_MODE "[1;37m([0;44;36m+[0;44;37m%+[1;37m)"
#define DEFAULT_STATUS_MAIL "[0;44;36m[[0;44;37mMail: [1;37m%M[0;44;36m]"
#define DEFAULT_STATUS_MSGCOUNT " Aw[0;44;36m[[1;37m%^[0;44;36m]"
#define DEFAULT_STATUS_NICK "%N"
#define DEFAULT_STATUS_NOTIFY " [0;44;36m[[37mAct: [1;37m%F[0;44;36m]"
#define DEFAULT_STATUS_OPER "[1;31m*[0;44;37m"
#define DEFAULT_STATUS_VOICE "[1;32m+[0;44;37m"
#define DEFAULT_STATUS_OVERWRITE "(overtype) "
#define DEFAULT_STATUS_QUERY " [0;44;36m[[37mQuery: [1;37m%Q[0;44;36m]"
#define DEFAULT_STATUS_SERVER " via %S"
#define DEFAULT_STATUS_TOPIC "%-"
#define DEFAULT_STATUS_UMODE "[1;37m([0;44;36m+[37m%#[1;37m)"
#define DEFAULT_STATUS_USER " * type /help for help "

#define DEFAULT_STATUS_DCCCOUNT  "[DCC  gets/%& sends/%&]"
#define DEFAULT_STATUS_CDCCCOUNT "[CDCC gets/%| offer/%|]"

#define DEFAULT_STATUS_OPER_KILLS "[0;44;36m[[37mnk[36m/[1;37m%K [0;44mok[36m/[1;37m%K[0;44;36m]"
#define DEFAULT_STATUS_USERS "[0;44;36m[[37mO[36m/[1;37m%! [0;44mN[36m/[1;37m%! [0;44mI[36m/[1;37m%! [0;44mV[36m/[1;37m%! [0;44mF[36m/[1;37m%![0;44;36m]"
#define DEFAULT_STATUS_CPU_SAVER " (%J)"

#define DEFAULT_STATUS_USER1 ""
#define DEFAULT_STATUS_USER2 ""
#define DEFAULT_STATUS_USER3 ""
#define DEFAULT_STATUS_USER4 ""
#define DEFAULT_STATUS_USER5 ""
#define DEFAULT_STATUS_USER6 ""
#define DEFAULT_STATUS_USER7 ""
#define DEFAULT_STATUS_USER8 ""
#define DEFAULT_STATUS_USER9 ""
#define DEFAULT_STATUS_USER10 ""
#define DEFAULT_STATUS_USER11 ""
#define DEFAULT_STATUS_USER12 ""
#define DEFAULT_STATUS_USER13 ""
#define DEFAULT_STATUS_USER14 ""
#define DEFAULT_STATUS_USER15 ""
#define DEFAULT_STATUS_USER16 ""
#define DEFAULT_STATUS_USER17 ""
#define DEFAULT_STATUS_USER18 ""
#define DEFAULT_STATUS_USER19 ""
#define DEFAULT_STATUS_WINDOW "[1;44;33m^^^^^^^^[0;44;37m"
#define DEFAULT_STATUS_FLAG ""
#define DEFAULT_STATUS_SCROLLBACK " (Scroll)"


#define DEFAULT_SUPPRESS_SERVER_MOTD 1
#define DEFAULT_TAB 1
#define DEFAULT_TAB_MAX 8
#define DEFAULT_UNDERLINE_VIDEO 1
#define DEFAULT_USERINFO ""
#define DEFAULT_VERBOSE_CTCP 1
#define DEFAULT_XTERM "rxvt"
#define DEFAULT_XTERM_OPTIONS "-bg black -fg white -fn vga11x19"

#define DEFAULT_DISPLAY_ANSI 1

#define DEFAULT_DCC_AUTOGET 1
#define DEFAULT_DCC_DLDIR "~"
#define DEFAULT_DCC_GET_LIMIT 0
#define DEFAULT_DCC_SEND_LIMIT 5
#define DEFAULT_DCC_QUEUE_LIMIT 10
#define DEFAULT_DCC_LIMIT 10
#define DEFAULT_FLOATING_POINT_MATH 0
#define DEFAULT_LLOOK 0
#define DEFAULT_CLOAK 0

#if defined(WINNT) || defined(__EMX__)
#define DEFAULT_CTOOLZ_DIR "~/bx-conf"
#define DEFAULT_SCRIPT_HELP_FILE DEFAULT_CTOOLZ_DIR"/BitchX.hlp"
#define DEFAULT_BITCHX_HELP_FILE DEFAULT_CTOOLZ_DIR"/BitchX.hlp"
#else
#define DEFAULT_CTOOLZ_DIR "~/.BitchX"
#define DEFAULT_SCRIPT_HELP_FILE DEFAULT_CTOOLZ_DIR"/BitchX.help"
#define DEFAULT_BITCHX_HELP_FILE DEFAULT_CTOOLZ_DIR"/BitchX.help"
#endif

#define DEFAULT_AINV 0
#define DEFAULT_ANNOY_KICK 0
#define DEFAULT_AOP_VAR 0
#define DEFAULT_KICK_OPS 1
#define DEFAULT_AUTO_REJOIN 1
#define DEFAULT_DEOPFLOOD 1
#define DEFAULT_DEOPFLOOD_TIME 30
#define DEFAULT_DEOP_ON_DEOPFLOOD 3
#define DEFAULT_DEOP_ON_KICKFLOOD 3
#define DEFAULT_KICK_IF_BANNED 1
#define DEFAULT_HACKING 0
#define DEFAULT_JOINFLOOD 1
#define DEFAULT_JOINFLOOD_TIME 50
#define DEFAULT_KICKFLOOD 1
#define DEFAULT_KICKFLOOD_TIME 30
#define DEFAULT_KICK_ON_DEOPFLOOD 3
#define DEFAULT_KICK_ON_JOINFLOOD 4
#define DEFAULT_KICK_ON_KICKFLOOD 4
#define DEFAULT_KICK_ON_NICKFLOOD 3
#define DEFAULT_KICK_ON_PUBFLOOD 30
#define DEFAULT_NICKFLOOD 1
#define DEFAULT_NICKFLOOD_TIME 30
#define DEFAULT_LAMELIST 1
#define DEFAULT_SHITLIST 1
#define DEFAULT_USERLIST 1
#define DEFAULT_PUBFLOOD 0
#define DEFAULT_PUBFLOOD_TIME 20
#define DEFAULT_PAD_CHAR ' '
#define DEFAULT_CONNECT_TIMEOUT 30
#define DEFAULT_STATUS_NO_REPEAT 1
#define DEFAULT_DISPATCH_UNKNOWN_COMMANDS 0
#define DEFAULT_SCROLLBACK_LINES 512


#define DEFAULT_USERMODE "+iw"  /* change this to the default usermode */
#define DEFAULT_OPERMODE "swfck"
#define DEFAULT_SWATCH "KILLS,CLIENTS,TRAFFIC,REHASH,KLINE,BOTS,OPER,SQUIT,SERVER,CONNECT,FLOOD,USER,STATS,NICK,ACTIVEK"

#define DEFAULT_CPU_SAVER_AFTER 0
#define DEFAULT_CPU_SAVER_EVERY 0
#define DEFAULT_NO_FAIL_DISCONNECT 0

#define DEFAULT_MAX_URL 20	/* this defines the MAX number of urls saved */


#define HACKED_DCC_WARNING     /*
				* gives a better warning for those weird 
				* people who like to give us useful files
				* like /dev/zero
				*/

#undef EMACS_KEYBINDS	       /* change this is you have problems with 
				* your keyboard
				*/
#define EXEC_COMMAND
#undef PUBLIC_ACCESS		/* 
				 * this define removes /load /exec commands
				 */
#if 0
#define CLOAKED   "emacs"	/*
				 * define this to the program you want to
				 * show up in "ps" and "top" to hide irc
				 * from evil sys-admins.
				 */
#endif
				 
#define HARD_REFRESH

#undef OLD_RANDOM_BEHAVIOR   /* semi randomness for randm() */

  /*
   * Experimental_match_hack is defined if you want the backslash to be
   * considered a real, literal character in a pattern matching unless it
   * followed by a special wildcard character (eg, *, %, or ?).
   * If you undef this, the long standing behavior will be the default.
   * This feature may become the default or may go away based on how
   * all this works out.
   */
  #define EXPERIMENTAL_MATCH_HACK
    

/* 
 * on certain systems we can define NON_BLOCKING to 1 
 * connects are then done alot differantly. We can perform actual work 
 * in the background, while connecting. This also protects us from certain
 * "bombs" that are available.  If you have trouble with this undef 
 * the NON_BLOCKING_CONNECTS. DCC sends/gets are much improved with this.
 */
 
#if defined(NBLOCK_POSIX) || defined(NBLOCK_BSD) || defined(NBLOCK_SYSV) && !defined(SOCKS)
#define NON_BLOCKING_CONNECTS 1
#define FAST_DCC_SENDS 1
#define DEFAULT_DCC_FAST 1       /* define this for fast default sends */
#else
#define DEFAULT_DCC_FAST 0
#endif

#if defined(HAVE_DLLIB)
#define WANT_DLL	1	/* define this for DLL and /loaddll commands */
#else
#if !defined(WINNT) && !defined(__EMX__) && !defined(_AIX)
#define WANT_DLL	1
#else
#undef WANT_DLL
#endif
#endif




#if defined(HEBREW) && !defined(TRANSLATE)
#define TRANSLATE 1
#endif
#if defined(TRANSLATE) && !defined(HEBREW)
#define HEBREW 1
#endif

#undef BITCHX_LITE
#if defined(BITCHX_LITE) && defined(WANT_TCL)
#undef BITCHX_LITE
#endif

#ifdef BITCHX_LITE
#undef WANT_DLL
#endif

#define DEFAULT_OPERVIEW_HIDE 0 /* defines the operview window. if hidden or not */ 
#define WANT_OPERVIEW 1

#define WANT_CDCC 1
#define WANT_FTP 1

#if defined(PUBLIC_ACCESS)
#undef EXEC_COMMAND
#undef WANT_TCL
#undef WANT_FTP
#endif


#endif /* __config_h_ */
