/*
 * IRC - Internet Relay Chat, include/class.h
 * Copyright (C) 1990 Darren Reed
 * Copyright (C) 1996 - 1997 Carlo Wood
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CLASS_H
#define CLASS_H

/*=========================================================================
 * Structures
 */

typedef struct Class {
  int class;
  int conFreq;
  int pingFreq;
  int maxLinks;
  long maxSendq;
  int links;
  struct Class *next;
} aClass;

/*=============================================================================
 * Macro's
 */

#define Class(x)	((x)->class)
#define ConFreq(x)	((x)->conFreq)
#define PingFreq(x)	((x)->pingFreq)
#define MaxLinks(x)	((x)->maxLinks)
#define MaxSendq(x)	((x)->maxSendq)
#define Links(x)	((x)->links)

#define ConfLinks(x)	(Class(x)->links)
#define ConfMaxLinks(x) (Class(x)->maxLinks)
#define ConfClass(x)	(Class(x)->class)
#define ConfConFreq(x)	(Class(x)->conFreq)
#define ConfPingFreq(x) (Class(x)->pingFreq)
#define ConfSendq(x)	(Class(x)->maxSendq)

#define FirstClass()	classes
#define NextClass(x)	((x)->next)

/*=============================================================================
 * Proto types
 */

extern aClass *find_class(int cclass);
extern aClass *make_class(void);
extern void free_class(aClass *tmp);
extern int get_con_freq(aClass *clptr);
extern int get_client_ping(aClient *acptr);
extern int get_conf_class(aConfItem *aconf);
extern int get_client_class(aClient *acptr);
extern void add_class(int class, int ping, int confreq, int maxli, long sendq);
extern void check_class(void);
extern void initclass(void);
extern void report_classes(aClient *sptr);
extern long get_sendq(aClient *cptr);

extern aClass *classes;

#endif /* CLASS_H */
