BEGIN {
  inheader=0;
  current_file="";
  print "/* This file is automatically generated with \"make proto\". DO NOT EDIT */"
  print ""
}

{
  if (FILENAME!=current_file) {
    print ""
    print "/*The following definitions come from ",FILENAME," */"
    print ""
    current_file=FILENAME
  }
  if (inheader) {
    if (match($0,"[)][ \t]*$")) {
      inheader = 0;
      printf "%s;\n",$0;
    } else {
      printf "%s\n",$0;
    }
    next;
  }
}

# we handle the loadparm.c fns separately

/^FN_LOCAL_BOOL/ {
  split($0,a,"[,()]")
  printf "BOOL %s(int );\n", a[2]
}

/^FN_LOCAL_STRING/ {
  split($0,a,"[,()]")
  printf "char *%s(int );\n", a[2]
}

/^FN_LOCAL_INT/ {
  split($0,a,"[,()]")
  printf "int %s(int );\n", a[2]
}

/^FN_LOCAL_CHAR/ {
  split($0,a,"[,()]")
  printf "char %s(int );\n", a[2]
}

/^FN_GLOBAL_BOOL/ {
  split($0,a,"[,()]")
  printf "BOOL %s(void);\n", a[2]
}

/^FN_GLOBAL_STRING/ {
  split($0,a,"[,()]")
  printf "char *%s(void);\n", a[2]
}

/^FN_GLOBAL_INT/ {
  split($0,a,"[,()]")
  printf "int %s(void);\n", a[2]
}

/^static|^extern/ || !/^[a-zA-Z]/ || /[;]/ {
  next;
}

!/^unsigned|^mode_t|^DIR|^user|^int|^char|^uint|^struct|^BOOL|^void|^time|^smb_shm_offset_t|^shm_offset_t|^enum remote_arch_types|^FILE/ {
  next;
}


/[(].*[)][ \t]*$/ {
    printf "%s;\n",$0;
    next;
}

/[(]/ {
  inheader=1;
  printf "%s\n",$0;
  next;
}

