#include <Xm/BulletinB.h>
#include <Xm/ComboBoxP.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>

#if !defined(CB_List)
#define CB_List(w) \
        (((XmComboBoxWidget)(w))->combo_box.list)
#endif

/* This test sees how the combobox insert child routine handles 
   adding children.

   RESULT:

   The following error message is given when adding a 4th child to the
   combobox.

Warning: 
    Name: combo
    Class: XmComboBox
    Applications cannot add children to XmComboBox widgets.

 */

int
main(int argc, char **argv)
{
  Widget toplevel, widget, bb, list, label, push;
  XtAppContext app;
  XmString item;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app, "ComBox", NULL, 0, &argc, argv, NULL, NULL);

  bb = XmCreateBulletinBoard(toplevel, "bb", NULL, 0);
  XtManageChild(bb);

  widget = XmCreateComboBox(bb, "combo", NULL, 0);

  /* add a label to the combobox */
  label = XmCreateLabel(widget, "label", NULL, 0);
  XtManageChild(label);

  push = XmCreatePushButton(widget, "push", NULL, 0);
  XtManageChild(push);

  /* use list routine to add items */
  list = CB_List(widget);

  item = XmStringCreateSimple("Item 1");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 2");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 3");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 4");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 5");
  XmListAddItem(list,item,0);

  XmComboBoxUpdate(widget);

  XtManageChild(widget);

  XtRealizeWidget(toplevel);

  XtAppMainLoop(app);

  exit(0);
}
