/* menu.c */

#include <stdio.h>
#include <X11/Intrinsic.h>

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/PushB.h>
#include <Xm/DrawingA.h>

void layoutApplication(Widget topLevel);
Widget topLevel, topForm, mainMenu, fileMenu, editMenu;
Widget helpMenu, optionMenu, popMenu, drawA, optionMenu2;


/* callback for option menu */
void drawCB(Widget wid, XtPointer cld, XtPointer cad)
{
}

void createOptionMenu(Widget parent)
{
  XmString lineStr, squareStr, circleStr;
  XmString optLab;

  optLab = XmStringCreateLocalized("Shape : ");
  lineStr = XmStringCreateLocalized("Line");
  squareStr = XmStringCreateLocalized("Square");
  circleStr = XmStringCreateLocalized("Circle");
  optionMenu = XmVaCreateSimpleOptionMenu(parent,
					  "optmenu", optLab, 'D', 0, drawCB,
					  XmVaPUSHBUTTON, lineStr, 'L', 0, 0,
					  XmVaPUSHBUTTON, squareStr, 'S', 0, 0,
					  XmVaPUSHBUTTON, circleStr, 'C', 0, 0,
					  0);
  XmStringFree(optLab);
  XmStringFree(lineStr);
  XmStringFree(squareStr);
  XmStringFree(circleStr);
  XtManageChild(optionMenu);

  XtVaSetValues(optionMenu,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, mainMenu,
		0);
}

int main(int argc, char *argv[])
{
  XtAppContext appContext;

  topLevel = XtAppInitialize(&appContext, "Menus", 0, 0,
					  &argc, argv, 0, 0, 0);

  layoutApplication(topLevel);
  XtRealizeWidget(topLevel);
  XtAppMainLoop(appContext);
  return 0;
}


Widget GXCreateOptionMenu(Widget parent, char **entries)
{
  Arg args[10];
  XmString *buttonArray;
  char **cptr;
  int cnt,i,n;
  Widget opt,pulldown;


  cptr=entries;
  cnt=0;
  do {
    cnt++;
    cptr++;    
  } while (*cptr);

  if (!(buttonArray=malloc(cnt*sizeof(XmString)))) {
    return NULL;
  }

  /* create the menu */
  for (i=0;i<cnt;i++)
    buttonArray[i]=XmStringCreateSimple(entries[i]);
  n=0;
  XtSetArg(args[n], XmNbuttonCount, cnt);  n++;
  XtSetArg(args[n], XmNbuttons, buttonArray); n++;
  pulldown = XmCreateSimplePulldownMenu(parent,"OptionMenuPulldown",args,n);
  for (i=0;i<cnt;i++)
    XmStringFree(buttonArray[i]);
  free(buttonArray);

  n=0;
  XtSetArg(args[n], XmNsubMenuId, pulldown);  n++;
  opt=XmCreateOptionMenu(parent,"OptionMenu",args,n);
  XtManageChild(opt);
  return opt;
}



void layoutApplication(Widget topLevel)
{
  char *entries[]={"Entry 1", "Entry 2", "Entry 3", NULL};
  /* note, later this will be a list of queries */
  topForm = XtVaCreateManagedWidget("topForm",
				    xmFormWidgetClass, topLevel,
				    0);
  
  createOptionMenu(topForm);

  optionMenu2=GXCreateOptionMenu(topForm,entries);
  /* handle it */
  XtManageChild(optionMenu2);
  XtVaSetValues(optionMenu2,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, mainMenu,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, optionMenu,
		0);

}
